/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.tempbonus;

import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.EquipBonus;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class EQToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject> {
    public String getTokenName() {
        return "EQ";
    }

    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail("Expected " + this.getFullTokenName() + ":<type>|<conditions>|BONUS but did not find a second pipe");
        }
        String constraints = value.substring(0, pipeLoc);
        String bonus = value.substring(pipeLoc + 1);
        String v = bonus.replaceAll(Pattern.quote("<this>"), obj.getKeyName());
        BonusObj bon = Bonus.newBonus((LoadContext)context, (String)v);
        if (bon == null) {
            return new ParseResult.Fail(this.getFullTokenName() + " was given invalid type: " + bonus, context);
        }
        bon.setTokenSource(this.getFullTokenName());
        EquipBonus eb = new EquipBonus(bon, constraints);
        context.getObjectContext().addToList(obj, ListKey.BONUS_EQUIP, (Object)eb);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.BONUS_EQUIP);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (EquipBonus eb : added) {
            String bonusText = eb.bonus.getLSTformat();
            bonusSet.add(eb.conditions + "|" + bonusText);
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public String getParentToken() {
        return "TEMPBONUS";
    }

    private String getFullTokenName() {
        return "TEMPBONUS:EQ";
    }

    protected char separator() {
        return '|';
    }
}

