/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DomainsToken
extends AbstractTokenWithSeparator<Deity>
implements CDOMPrimaryToken<Deity> {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    public String getTokenName() {
        return "DOMAINS";
    }

    protected char separator() {
        return ',';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Deity deity, String value) {
        String tokString;
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        StringTokenizer commaTok = new StringTokenizer(pipeTok.nextToken(), ",");
        CDOMReference dl = Deity.DOMAINLIST;
        ArrayList<AssociatedPrereqObject> proList = new ArrayList<AssociatedPrereqObject>();
        boolean first = true;
        boolean foundAll = false;
        boolean foundOther = false;
        boolean foundClear = false;
        while (commaTok.hasMoreTokens()) {
            Object ref;
            tokString = commaTok.nextToken();
            if (this.looksLikeAPrerequisite(tokString)) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + ": PRExxx was comma delimited : " + value, context);
            }
            if (".CLEAR".equals(tokString)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), (CDOMObject)deity, dl);
                foundClear = true;
            } else if (tokString.startsWith(".CLEAR.")) {
                String clearText = tokString.substring(7);
                ref = "ALL".equals(clearText) || "ANY".equals(clearText) ? context.getReferenceContext().getCDOMAllReference(DOMAIN_CLASS) : context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, clearText);
                context.getListContext().removeFromList(this.getTokenName(), (CDOMObject)deity, dl, (CDOMReference)ref);
                foundClear = true;
            } else if ("ALL".equals(tokString) || "ANY".equals(tokString)) {
                ref = context.getReferenceContext().getCDOMAllReference(DOMAIN_CLASS);
                proList.add(context.getListContext().addToList(this.getTokenName(), (CDOMObject)deity, dl, (CDOMReference)ref));
                foundAll = true;
            } else {
                ref = context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, tokString);
                proList.add(context.getListContext().addToList(this.getTokenName(), (CDOMObject)deity, dl, (CDOMReference)ref));
                foundOther = true;
            }
            first = false;
        }
        if (foundAll && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ALL and a specific reference: " + value, context);
        }
        while (pipeTok.hasMoreTokens()) {
            if (foundClear) {
                return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR or .CLEAR. in " + this.getTokenName(), context);
            }
            tokString = pipeTok.nextToken();
            Prerequisite prereq = this.getPrerequisite(tokString);
            if (prereq == null) {
                return new ParseResult.Fail("   (Did you put items after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            for (AssociatedPrereqObject ao : proList) {
                ao.addPrerequisite(prereq);
            }
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Deity deity) {
        CDOMReference dl = Deity.DOMAINLIST;
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)deity, dl);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)",.CLEAR.", (boolean)true));
        }
        MapToList mtl = changes.getAddedAssociations();
        if (mtl != null && !mtl.isEmpty()) {
            HashMapToList m = new HashMapToList();
            for (CDOMReference ab : mtl.getKeySet()) {
                for (AssociatedPrereqObject assoc : mtl.getListFor((Object)ab)) {
                    m.addToListFor(new HashSet(assoc.getPrerequisiteList()), (Object)ab);
                }
            }
            TreeSet<String> set = new TreeSet<String>();
            for (Set prereqs : m.getKeySet()) {
                TreeSet domainSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
                domainSet.addAll(m.getListFor((Object)prereqs));
                StringBuilder sb = new StringBuilder(ReferenceUtilities.joinLstFormat(domainSet, (String)",", (boolean)true));
                if (prereqs != null && !prereqs.isEmpty()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, prereqs));
                }
                set.add(sb.toString());
            }
            list.addAll(set);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Deity> getTokenClass() {
        return Deity.class;
    }
}

