/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Logarithm
extends PostfixMathCommand {
    private static final double LOG10 = Math.log(10.0);
    private static final Complex CLOG10 = new Complex(Math.log(10.0), 0.0);

    public Logarithm() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        stack.push(this.log(e));
    }

    public Object log(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).log().div(CLOG10);
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return new Double(Math.log(d) / LOG10);
            }
            if (d != d) {
                return new Double(Double.NaN);
            }
            Complex complex = new Complex(d);
            return complex.log().div(CLOG10);
        }
        throw new ParseException("Invalid parameter type");
    }
}

