/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MonccskillToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "MONCCSKILL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        boolean firstToken = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        CDOMGroupRef monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, new String[]{"Monster"});
        while (tok.hasMoreTokens()) {
            CDOMReference<Skill> skill;
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                skill = "ALL".equals(clearText) ? context.getReferenceContext().getCDOMAllReference(SKILL_CLASS) : this.getSkillReference(context, clearText);
                if (skill == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getListContext().removeFromList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList, skill);
            } else {
                if ("ALL".equals(tokText)) {
                    foundAny = true;
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else {
                    foundOther = true;
                    skill = this.getSkillReference(context, tokText);
                }
                if (skill == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList, skill);
                apo.setAssociation(AssociationKey.SKILL_COST, (Object)SkillCost.CROSS_CLASS);
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)tokText);
    }

    public String[] unparse(LoadContext context, Race race) {
        MapToList map;
        CDOMGroupRef monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, new String[]{"Monster"});
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)"|.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((map = changes.getAddedAssociations()) != null && !map.isEmpty()) {
            Set added = map.getKeySet();
            for (CDOMReference ab : added) {
                for (AssociatedPrereqObject assoc : map.getListFor((Object)ab)) {
                    if (SkillCost.CROSS_CLASS.equals(assoc.getAssociation(AssociationKey.SKILL_COST))) continue;
                    context.addWriteMessage("Skill Cost must be CROSS_CLASS for Token " + this.getTokenName());
                    return null;
                }
            }
            list.add(ReferenceUtilities.joinLstFormat((Collection)added, (String)"|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

