/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Event;
import gmgen.plugin.State;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import pcgen.util.Logging;

public class Spell
extends Event {
    protected String anEffect;
    protected String aName;
    protected String aPlayer;
    protected String aStatus = "Active";
    protected boolean anAlert;
    protected int aDuration;

    public Spell(String name, String player, String effect, int duration, int init, boolean alert) {
        super(name, player, effect, duration, init, alert);
    }

    public Spell(Element spell) {
        try {
            String theName = spell.getAttribute("name").getValue();
            String thePlayer = spell.getAttribute("player").getValue();
            State theStatus = State.getState(spell.getAttribute("status").getValue());
            String theEffect = spell.getAttribute("effect").getValue();
            int theDuration = spell.getChild("Initiative").getAttribute("duration").getIntValue();
            int anInit = spell.getChild("Initiative").getAttribute("initiative").getIntValue();
            boolean theAlert = spell.getChild("Initiative").getAttribute("alert").getBooleanValue();
            this.setValues(theName, thePlayer, theStatus, theEffect, theDuration, anInit, theAlert);
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    @Override
    public String getEndText() {
        return "Spell " + this.getName() + "'s Duration Expired";
    }

    @Override
    public Vector<Object> getRowVector(List<String> columnOrder) {
        Vector<Object> rowVector = new Vector<Object>();
        for (String columnName : columnOrder) {
            if (columnName.equals("Name")) {
                rowVector.add("Spell: " + this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add("Owner: " + this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add((Object)this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                rowVector.add("" + this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add("");
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add("-");
        }
        return rowVector;
    }

    @Override
    public Element getSaveElement() {
        Element retElement = new Element("Spell");
        Element initiative = new Element("Initiative");
        initiative.setAttribute("initiative", this.init.getCurrentInitiative() + "");
        initiative.setAttribute("duration", this.getDuration() + "");
        initiative.setAttribute("alert", this.isAlert() + "");
        retElement.addContent((Content)initiative);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus().name());
        retElement.setAttribute("effect", this.getEffect());
        return retElement;
    }
}

