/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.Collection;
import pcgen.cdom.base.BasicClassIdentity;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseInformationUtilities;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChoiceManager;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.rules.context.LoadContext;

public class BasicChooseInformation<T>
implements ChooseInformation<T> {
    private final PrimitiveChoiceSet<T> pcs;
    private final String setName;
    private String title = null;
    private Chooser<T> choiceActor;

    public BasicChooseInformation(String name, PrimitiveChoiceSet<T> choice) {
        if (choice == null) {
            throw new IllegalArgumentException("PrimitiveChoiceSet cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.pcs = choice;
        this.setName = name;
    }

    @Override
    public void setChoiceActor(Chooser<T> actor) {
        this.choiceActor = actor;
    }

    @Override
    public String encodeChoice(T item) {
        return this.choiceActor.encodeChoice(item);
    }

    @Override
    public T decodeChoice(LoadContext context, String persistenceFormat) {
        return this.choiceActor.decodeChoice(context, persistenceFormat);
    }

    @Override
    public Chooser<T> getChoiceActor() {
        return this.choiceActor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicChooseInformation) {
            BasicChooseInformation other = (BasicChooseInformation)obj;
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return this.setName.equals(other.setName) && this.pcs.equals(other.pcs);
        }
        return false;
    }

    public int hashCode() {
        return this.setName.hashCode() + 29;
    }

    @Override
    public String getLSTformat() {
        return this.pcs.getLSTformat(false);
    }

    @Override
    public ClassIdentity<? super T> getClassIdentity() {
        return BasicClassIdentity.getInstance(this.pcs.getChoiceClass());
    }

    @Override
    public Collection<? extends T> getSet(PlayerCharacter pc) {
        return this.pcs.getSet(pc);
    }

    @Override
    public String getName() {
        return this.setName;
    }

    public void setTitle(String choiceTitle) {
        this.title = choiceTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.pcs.getGroupingState();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, T item) {
        this.choiceActor.restoreChoice(pc, owner, item);
    }

    @Override
    public ChoiceManagerList<T> getChoiceManager(ChooseDriver owner, int cost) {
        return new CDOMChoiceManager(owner, this, null, cost);
    }

    @Override
    public CharSequence composeDisplay(Collection<? extends T> collection) {
        return ChooseInformationUtilities.buildEncodedString(this, collection);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, T item) {
        this.choiceActor.removeChoice(pc, owner, item);
    }
}

