/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.content.AbilitySelection;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class CollectionToAbilitySelection
implements PrimitiveChoiceSet<AbilitySelection> {
    private final PrimitiveCollection<Ability> collection;
    private final CDOMSingleRef<AbilityCategory> category;
    private static Stack<Ability> infiniteLoopDetectionStack = new Stack();

    public CollectionToAbilitySelection(CDOMSingleRef<AbilityCategory> cat, PrimitiveCollection<Ability> coll) {
        if (cat == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        if (coll == null) {
            throw new IllegalArgumentException("PrimitiveCollection must not be null");
        }
        this.category = cat;
        this.collection = coll;
    }

    @Override
    public Class<? super AbilitySelection> getChoiceClass() {
        return AbilitySelection.class;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.collection.getGroupingState();
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.collection.getLSTformat(useAny);
    }

    @Override
    public Collection<AbilitySelection> getSet(PlayerCharacter pc) {
        Collection<AbilityWithChoice> aColl = this.collection.getCollection(pc, new ExpandingConverter(pc));
        HashSet<AbilitySelection> returnSet = new HashSet<AbilitySelection>();
        for (AbilityWithChoice a : aColl) {
            this.processAbility(pc, returnSet, a);
        }
        return returnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAbility(PlayerCharacter character, Set<AbilitySelection> returnSet, AbilityWithChoice awc) {
        Ability a = awc.getAbility();
        if (infiniteLoopDetectionStack.contains(a)) {
            Stack<Ability> current = new Stack<Ability>();
            current.addAll(infiniteLoopDetectionStack);
            Logging.errorPrint("Error: Circular Expansion Found: " + this.reportCircularExpansion(current));
            return;
        }
        try {
            infiniteLoopDetectionStack.push(a);
            if (a.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                returnSet.addAll(this.addMultiplySelectableAbility(character, a, awc.getChoice()));
            } else {
                returnSet.add(new AbilitySelection(a, null));
            }
        }
        finally {
            infiniteLoopDetectionStack.pop();
        }
    }

    private Collection<AbilitySelection> addMultiplySelectableAbility(PlayerCharacter aPC, Ability ability, String subName) {
        boolean isPattern = false;
        String nameRoot = null;
        if (subName != null) {
            int percIdx = subName.indexOf(37);
            if (percIdx > -1) {
                isPattern = true;
                nameRoot = subName.substring(0, percIdx);
            } else if (subName.length() != 0) {
                nameRoot = subName;
            }
        }
        ChooseInformation<?> chooseInfo = ability.get(ObjectKey.CHOOSE_INFO);
        List<String> availableList = this.getAvailableList(aPC, chooseInfo);
        if (nameRoot != null && nameRoot.length() != 0) {
            for (int n = availableList.size() - 1; n >= 0; --n) {
                String aString = availableList.get(n);
                if (aString.startsWith(nameRoot)) continue;
                availableList.remove(n);
            }
            if (isPattern && !availableList.isEmpty()) {
                availableList.add(nameRoot);
            }
        }
        ArrayList<AbilitySelection> returnList = new ArrayList<AbilitySelection>(availableList.size());
        for (String s : availableList) {
            returnList.add(new AbilitySelection(ability, s));
        }
        return returnList;
    }

    private <T> List<String> getAvailableList(PlayerCharacter aPC, ChooseInformation<T> chooseInfo) {
        ArrayList<String> availableList = new ArrayList<String>();
        Collection<T> tempAvailList = chooseInfo.getSet(aPC);
        for (T o : tempAvailList) {
            availableList.add(chooseInfo.encodeChoice(o));
        }
        return availableList;
    }

    private String reportCircularExpansion(Stack<Ability> s) {
        StringBuilder sb = new StringBuilder(2000);
        this.processCircularExpansion(sb, s);
        sb.append("    which is a circular reference");
        return sb.toString();
    }

    private void processCircularExpansion(StringBuilder sb, Stack<Ability> s) {
        Ability a = s.pop();
        if (!s.isEmpty()) {
            this.processCircularExpansion(sb, s);
            sb.append("     which includes");
        }
        sb.append(a.getCDOMCategory()).append(' ').append(a.getKeyName());
        sb.append(" selects items: ");
        sb.append(a.get(ObjectKey.CHOOSE_INFO).getLSTformat());
        sb.append('\n');
    }

    public CDOMSingleRef<AbilityCategory> getCategory() {
        return this.category;
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CollectionToAbilitySelection && ((CollectionToAbilitySelection)obj).collection.equals(this.collection);
    }

    private static class AbilityWithChoice {
        private final Ability ability;
        private final String choice;

        public AbilityWithChoice(Ability a, String c) {
            this.ability = a;
            this.choice = c;
        }

        public Ability getAbility() {
            return this.ability;
        }

        public String getChoice() {
            return this.choice;
        }

        public int hashCode() {
            return this.ability.hashCode() ^ (this.choice == null ? 17 : this.choice.hashCode());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AbilityWithChoice) {
                AbilityWithChoice other = (AbilityWithChoice)o;
                if (this.choice == null && other.choice != null) {
                    return false;
                }
                return this.ability.equals(other.ability) && (this.choice == other.choice || this.choice.equals(other.choice));
            }
            return false;
        }
    }

    public static class ExpandingConverter
    implements Converter<Ability, AbilityWithChoice> {
        private final PlayerCharacter character;

        public ExpandingConverter(PlayerCharacter pc) {
            this.character = pc;
        }

        @Override
        public Collection<AbilityWithChoice> convert(ObjectContainer<Ability> ref) {
            HashSet<AbilityWithChoice> returnSet = new HashSet<AbilityWithChoice>();
            for (Ability a : ref.getContainedObjects()) {
                this.processAbility(ref, returnSet, a);
            }
            return returnSet;
        }

        private void processAbility(ObjectContainer<Ability> ref, Set<AbilityWithChoice> returnSet, Ability a) {
            String choice = null;
            if (ref instanceof CDOMReference) {
                choice = ((CDOMReference)ref).getChoice();
            }
            returnSet.add(new AbilityWithChoice(a, choice));
        }

        @Override
        public Collection<AbilityWithChoice> convert(ObjectContainer<Ability> ref, PrimitiveFilter<Ability> lim) {
            HashSet<AbilityWithChoice> returnSet = new HashSet<AbilityWithChoice>();
            for (Ability a : ref.getContainedObjects()) {
                if (!lim.allow(this.character, a)) continue;
                this.processAbility(ref, returnSet, a);
            }
            return returnSet;
        }
    }
}

