/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.core.SettingsHandler;

public class ChallengeRating
extends ConcretePrereqObject {
    public static final ChallengeRating ZERO = new ChallengeRating(FormulaFactory.ZERO);
    private final Formula rating;

    public ChallengeRating(Formula crFormula) {
        if (!crFormula.isValid()) {
            throw new IllegalArgumentException("ChallengeRating Formula must be valid");
        }
        this.rating = crFormula;
    }

    public Formula getRating() {
        return this.rating;
    }

    public String getLSTformat() {
        String str = this.rating.toString();
        if (str.charAt(0) == '-') {
            str = "1/" + str.substring(1);
        }
        return str;
    }

    public Integer toInteger() {
        return SettingsHandler.getGame().getCRInteger(this.rating.toString());
    }

    public int hashCode() {
        return this.rating.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChallengeRating) {
            ChallengeRating other = (ChallengeRating)obj;
            return this.rating.equals(other.rating) && this.equalsPrereqObject(other);
        }
        return false;
    }
}

