/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.AutoLanguageUnconditionalFacet;
import pcgen.cdom.facet.base.AbstractQualifiedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.meta.CorePerspective;
import pcgen.cdom.meta.CorePerspectiveDB;
import pcgen.cdom.meta.FacetBehavior;
import pcgen.cdom.meta.PerspectiveLocation;
import pcgen.core.Language;
import pcgen.core.QualifiedObject;

public class AutoLanguageFacet
extends AbstractQualifiedListFacet<QualifiedObject<CDOMReference<Language>>>
implements DataFacetChangeListener<CharID, CDOMObject>,
PerspectiveLocation {
    private AutoLanguageUnconditionalFacet autoLanguageUnconditionalFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        List<QualifiedObject<CDOMReference<Language>>> list = cdo.getSafeListFor(ListKey.AUTO_LANGUAGES);
        if (list != null) {
            this.separateAll(id, list, cdo);
        }
        if ((list = cdo.getSafeListFor(ListKey.AUTO_LANGUAGE)) != null) {
            this.separateAll(id, list, cdo);
        }
    }

    private void separateAll(CharID id, List<QualifiedObject<CDOMReference<Language>>> list, CDOMObject cdo) {
        for (QualifiedObject<CDOMReference<Language>> qRef : list) {
            if (qRef.hasPrerequisites()) {
                this.add(id, qRef, cdo);
                continue;
            }
            this.autoLanguageUnconditionalFacet.addAll(id, qRef.getRawObject().getContainedObjects(), cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        this.removeAll(id, cdo);
        this.autoLanguageUnconditionalFacet.removeAll(id, cdo);
    }

    public List<Language> getAutoLanguage(CharID id) {
        ArrayList<Language> list = new ArrayList<Language>();
        for (QualifiedObject qo : this.getQualifiedSet(id)) {
            Collection langList = ((CDOMReference)qo.getRawObject()).getContainedObjects();
            for (Language l : langList) {
                list.add(l);
            }
        }
        return list;
    }

    public void setAutoLanguageUnconditionalFacet(AutoLanguageUnconditionalFacet autoLanguageUnconditionalFacet) {
        this.autoLanguageUnconditionalFacet = autoLanguageUnconditionalFacet;
    }

    public void init() {
        CorePerspectiveDB.register(CorePerspective.LANGUAGE, FacetBehavior.CONDITIONAL, this);
    }

    @Override
    public String getIdentity() {
        return "AUTO:LANG|<ref> (with prerequisite)";
    }
}

