/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.core.Globals;
import pcgen.core.Skill;

public class BonusSkillRankChangeFacet
extends AbstractStorageFacet<CharID> {
    private final SkillRankChangeSupport support = new SkillRankChangeSupport();
    private BonusCheckingFacet bonusCheckingFacet;

    public void reset(CharID id) {
        HashMap<Skill, Double> map = this.getConstructingInfo(id);
        for (Skill s : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
            double newValue = this.bonusCheckingFacet.getBonus(id, "SKILLRANK", s.getKeyName());
            for (Type singleType : s.getTrueTypeList(false)) {
                newValue += this.bonusCheckingFacet.getBonus(id, "SKILLRANK", "TYPE." + singleType);
            }
            Double oldValue = map.get(s);
            if (oldValue != null && newValue == oldValue) continue;
            map.put(s, newValue);
            this.support.fireSkillRankChange(id, s, oldValue, newValue);
        }
    }

    private HashMap<Skill, Double> getConstructingInfo(CharID id) {
        HashMap<Skill, Double> map = this.getInfo(id);
        if (map == null) {
            map = new HashMap();
            this.setCache(id, map);
        }
        return map;
    }

    private HashMap<Skill, Double> getInfo(CharID id) {
        return (HashMap)this.getCache(id);
    }

    public void addSkillRankChangeListener(SkillRankChangeListener listener) {
        this.support.addSkillRankChangeListener(listener);
    }

    public void removeSkillRankChangeListener(SkillRankChangeListener listener) {
        this.support.removeSkillRankChangeListener(listener);
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        HashMap<Skill, Double> map = this.getInfo(source);
        if (map != null) {
            this.getConstructingInfo(copy).putAll(map);
        }
    }

    public double getRank(CharID id, Skill skill) {
        Double rank;
        HashMap<Skill, Double> map = this.getInfo(id);
        if (map != null && (rank = map.get(skill)) != null) {
            return rank;
        }
        return 0.0;
    }

    public static class SkillRankChangeSupport {
        private List<SkillRankChangeListener> listeners = new ArrayList<SkillRankChangeListener>();

        public synchronized void addSkillRankChangeListener(SkillRankChangeListener listener) {
            this.listeners.add(listener);
        }

        public synchronized void removeSkillRankChangeListener(SkillRankChangeListener listener) {
            this.listeners.remove(listener);
        }

        public synchronized SkillRankChangeListener[] getSkillRankChangeListeners() {
            return this.listeners.toArray(new SkillRankChangeListener[0]);
        }

        public void fireSkillRankChange(CharID id, Skill skill, Number oldValue, Number newValue) {
            SkillRankChangeEvent bce = new SkillRankChangeEvent(id, skill, oldValue, newValue);
            for (SkillRankChangeListener target : this.listeners) {
                target.bonusChange(bce);
            }
        }
    }

    public static class SkillRankChangeEvent {
        private final CharID charID;
        private final Skill skill;
        private final Number oldVal;
        private final Number newVal;

        public SkillRankChangeEvent(CharID id, Skill sk, Number oldValue, Number newValue) {
            this.charID = id;
            this.skill = sk;
            this.oldVal = oldValue;
            this.newVal = newValue;
        }

        public CharID getCharID() {
            return this.charID;
        }

        public Skill getSkill() {
            return this.skill;
        }

        public Number getOldVal() {
            return this.oldVal;
        }

        public Number getNewVal() {
            return this.newVal;
        }
    }

    public static interface SkillRankChangeListener {
        public void bonusChange(SkillRankChangeEvent var1);
    }
}

