/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.DataSetInitializedFacet;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.facet.DataSetInitializationFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.helper.AvailableSpell;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Globals;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;

public class MasterAvailableSpellFacet
extends AbstractListFacet<DataSetID, AvailableSpell>
implements DataSetInitializedFacet {
    private DataSetInitializationFacet datasetInitializationFacet;

    @Override
    public synchronized void initialize(LoadContext lc) {
        DataSetID dsID = lc.getDataSetID();
        MasterListInterface masterLists = Globals.getMasterLists();
        ArrayList useLists = new ArrayList();
        block0: for (CDOMReference<CDOMList<?>> cDOMReference : masterLists.getActiveLists()) {
            Collection<CDOMList<?>> lists = cDOMReference.getContainedObjects();
            for (CDOMList<?> list : lists) {
                if (!(list instanceof ClassSpellList) && !(list instanceof DomainSpellList)) continue;
                useLists.add(cDOMReference);
                continue block0;
            }
        }
        for (CDOMReference cDOMReference : useLists) {
            for (Spell spell : masterLists.getObjects(cDOMReference)) {
                Collection<AssociatedPrereqObject> assoc = masterLists.getAssociations(cDOMReference, spell);
                for (AssociatedPrereqObject apo : assoc) {
                    int lvl = apo.getAssociation(AssociationKey.SPELL_LEVEL);
                    for (CDOMList<Spell> cDOMList : cDOMReference.getContainedObjects()) {
                        AvailableSpell as = new AvailableSpell(cDOMList, spell, lvl);
                        if (apo.hasPrerequisites()) {
                            as.addAllPrerequisites(apo.getPrerequisiteList());
                        }
                        this.add(dsID, as);
                    }
                }
            }
        }
    }

    public List<AvailableSpell> getAllSpellsInList(CDOMList<Spell> spellList, DataSetID dsID) {
        ArrayList<AvailableSpell> spellsInList = new ArrayList<AvailableSpell>();
        Collection spells = this.getSet(dsID);
        for (AvailableSpell as : spells) {
            if (!as.getSpelllist().equals(spellList)) continue;
            spellsInList.add(as);
        }
        return spellsInList;
    }

    public List<AvailableSpell> getMatchingSpellsInList(CDOMList<Spell> spellList, DataSetID dsID, Spell spell) {
        ArrayList<AvailableSpell> spellsInList = new ArrayList<AvailableSpell>();
        Collection spells = this.getSet(dsID);
        for (AvailableSpell as : spells) {
            if (!as.getSpelllist().equals(spellList) || !as.getSpell().equals(spell)) continue;
            spellsInList.add(as);
        }
        return spellsInList;
    }

    public void setDataSetInitializationFacet(DataSetInitializationFacet datasetInitializationFacet) {
        this.datasetInitializationFacet = datasetInitializationFacet;
    }

    public void init() {
        this.datasetInitializationFacet.addDataSetInitializedFacet(this);
    }
}

