/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.CDOMObjectSourceFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.util.enumeration.Load;

public class UnencumberedLoadFacet
extends AbstractSourcedListFacet<CharID, Load>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectSourceFacet cdomSourceFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        Load load = cdo.get(ObjectKey.UNENCUMBERED_LOAD);
        if (load != null) {
            this.add(dfce.getCharID(), load, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    @Override
    protected Map<Load, Set<Object>> getComponentMap() {
        return new TreeMap<Load, Set<Object>>();
    }

    public Load getBestLoad(CharID id) {
        TreeMap map = (TreeMap)this.getCachedMap(id);
        if (map == null || map.isEmpty()) {
            return Load.LIGHT;
        }
        return (Load)((Object)map.lastKey());
    }

    public boolean ignoreLoad(CharID id, Load load) {
        return this.getBestLoad(id).compareTo(load) >= 0;
    }

    public void setCdomSourceFacet(CDOMObjectSourceFacet cdomSourceFacet) {
        this.cdomSourceFacet = cdomSourceFacet;
    }

    public void init() {
        this.cdomSourceFacet.addDataFacetChangeListener(this);
    }
}

