/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.content.AbilitySelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.util.Logging;

public class AbilitySelector
extends ConcretePrereqObject
implements QualifyingObject,
ChooseSelectionActor<AbilitySelection> {
    private final String source;
    private final CDOMSingleRef<AbilityCategory> category;
    private final Nature nature;

    public AbilitySelector(String token, CDOMSingleRef<AbilityCategory> cat, Nature nat) {
        this.category = cat;
        this.nature = nat;
        this.source = token;
    }

    public CDOMSingleRef<AbilityCategory> getAbilityCategory() {
        return this.category;
    }

    public Nature getNature() {
        return this.nature;
    }

    @Override
    public void applyChoice(ChooseDriver obj, AbilitySelection as, PlayerCharacter pc) {
        CNAbility cna = CNAbilityFactory.getCNAbility(this.category.resolvesTo(), this.nature, (Ability)as.getObject());
        CNAbilitySelection cnas = new CNAbilitySelection(cna, (String)as.getSelection());
        pc.associateSelection(as, cnas);
        pc.addAbility(cnas, obj, this);
    }

    @Override
    public String getLstFormat() throws PersistenceLayerException {
        return "%LIST";
    }

    @Override
    public void removeChoice(ChooseDriver obj, AbilitySelection as, PlayerCharacter pc) {
        CNAbilitySelection cnas = pc.getAssociatedSelection(as);
        if (cnas == null) {
            Logging.log(Logging.WARNING, "Unexpected: Found null CNAS");
        } else {
            pc.removeAbility(cnas, obj, this);
        }
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return this.category.hashCode() ^ this.nature.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbilitySelector) {
            AbilitySelector other = (AbilitySelector)o;
            return this.source.equals(other.source) && this.category.equals(other.category) && this.nature.equals((Object)other.nature);
        }
        return false;
    }

    @Override
    public Class<AbilitySelection> getChoiceClass() {
        return AbilitySelection.class;
    }
}

