/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.math.BigDecimal;

public class Capacity {
    public static final BigDecimal UNLIMITED = new BigDecimal(-1);
    public static final Capacity ANY = new Capacity(null, UNLIMITED);
    private final String type;
    private final BigDecimal limit;

    public Capacity(String capacityType, BigDecimal capacityLimit) {
        this.type = capacityType;
        this.limit = capacityLimit;
    }

    public BigDecimal getCapacity() {
        return this.limit;
    }

    public String getType() {
        return this.type;
    }

    public static Capacity getTotalCapacity(BigDecimal capacity) {
        return new Capacity(null, capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("Capacity: ");
        sb.append(this.type == null ? "Total" : this.type);
        sb.append('=');
        sb.append(UNLIMITED.equals(this.limit) ? "UNLIMITED" : this.limit);
        return sb.toString();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode() ^ this.limit.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Capacity) {
            Capacity other = (Capacity)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return this.limit.equals(other.limit);
        }
        return false;
    }
}

