/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.SortedMap;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Campaign;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.lst.CampaignOutput;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public final class CustomData {
    private static final String AUTO_GEN_WARN_LINE_1 = "#This file auto-generated by PCGen. Manual editing not recommended.";
    private static final String AUTO_GEN_WARN_LINE_2 = "#Ensure PCGen is not running before editing. Make backups as errors may result in data loss.";
    private static boolean customItemsLoaded = false;

    private CustomData() {
    }

    public static BufferedReader getCustomEquipmentReader() {
        return CustomData.getReader(CustomData.customEquipmentFilePath());
    }

    public static String customBioSetFilePath(boolean usePath) {
        return CustomData.getCustomPath("BioSet", usePath);
    }

    public static String customClassFilePath(boolean usePath) {
        return CustomData.getCustomPath("Classes", usePath);
    }

    public static String customDeityFilePath(boolean usePath) {
        return CustomData.getCustomPath("Deities", usePath);
    }

    public static String customDomainFilePath(boolean usePath) {
        return CustomData.getCustomPath("Domains", usePath);
    }

    public static String customAbilityFilePath(boolean usePath) {
        return CustomData.getCustomPath("Abilities", usePath);
    }

    public static String customFeatFilePath(boolean usePath) {
        return CustomData.getCustomPath("Feats", usePath);
    }

    public static String customLanguageFilePath(boolean usePath) {
        return CustomData.getCustomPath("Languages", usePath);
    }

    public static String customPurchaseModeFilePath(boolean usePath, String gmName) {
        return CustomData.getCustomPath("PointBuyMethods", usePath, gmName);
    }

    public static String customRaceFilePath(boolean usePath) {
        return CustomData.getCustomPath("Races", usePath);
    }

    public static String customSkillFilePath(boolean usePath) {
        return CustomData.getCustomPath("Skills", usePath);
    }

    public static String customSpellFilePath(boolean usePath) {
        return CustomData.getCustomPath("Spells", usePath);
    }

    public static String customTemplateFilePath(boolean usePath) {
        return CustomData.getCustomPath("Templates", usePath);
    }

    public static void writeCustomFiles() {
        CustomData.ensureCustomDirExists();
        CustomData.writePurchaseModeConfiguration();
        if (!customItemsLoaded) {
            return;
        }
        CustomData.writeCustomBioSet();
        CustomData.writeCustomClasses();
        CustomData.writeCustomDeities();
        CustomData.writeCustomDomains();
        CustomData.writeCustomAbilities();
        CustomData.writeCustomFeats();
        CustomData.writeCustomItems();
        CustomData.writeCustomLanguages();
        CustomData.writeCustomRaces();
        CustomData.writeCustomSkills();
        CustomData.writeCustomSpells();
        CustomData.writeCustomTemplates();
        CustomData.writeCustomSources();
    }

    private static void ensureCustomDirExists() {
        File customDir = new File(PCGenSettings.getCustomDir() + File.separator + SettingsHandler.getGame().getName());
        if (!customDir.exists()) {
            try {
                customDir.mkdirs();
            }
            catch (SecurityException se) {
                Logging.errorPrint("Unable to create custom data directory '" + customDir.getPath() + "' due the following error.", se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCustomItems() {
        if (!customItemsLoaded && new File(CustomData.customEquipmentFilePath()).exists()) {
            if (Logging.isLoggable(Logging.WARNING)) {
                Logging.log(Logging.WARNING, "Custom items had not been loaded, so we won't save them this time.");
            }
            return;
        }
        CustomData.ensureCustomDirExists();
        BufferedWriter bw = CustomData.getCustomEquipmentWriter();
        if (bw == null) {
            return;
        }
        try {
            bw.write(AUTO_GEN_WARN_LINE_1);
            bw.newLine();
            bw.write(AUTO_GEN_WARN_LINE_2);
            bw.newLine();
            for (Equipment aEq : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
                if (!aEq.isType("Custom") || aEq.isType("AUTO_GEN")) continue;
                aEq.save(bw);
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomItems", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomItems while closing", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePurchaseModeConfiguration() {
        CustomData.ensureCustomDirExists();
        BufferedWriter bw = CustomData.getPurchaseModeWriter();
        SortedMap<Integer, PointBuyCost> pbStatCosts = SettingsHandler.getGame().getPointBuyStatCostMap();
        if (bw == null || pbStatCosts == null) {
            return;
        }
        try {
            bw.write("#");
            bw.newLine();
            bw.write(AUTO_GEN_WARN_LINE_1);
            bw.newLine();
            bw.write(AUTO_GEN_WARN_LINE_2);
            bw.newLine();
            bw.write("#");
            bw.newLine();
            bw.write("# Point-buy ability score costs");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            if (pbStatCosts.size() > 0) {
                for (Integer statValue : pbStatCosts.keySet()) {
                    PointBuyCost pbc = (PointBuyCost)pbStatCosts.get(statValue);
                    bw.write("STAT:" + statValue.toString() + "\t\tCOST:" + Integer.toString(pbc.getBuyCost()));
                    int iCount = pbc.getPrerequisiteCount();
                    if (iCount != 0) {
                        StringWriter writer = new StringWriter();
                        for (Prerequisite prereq : pbc.getPrerequisiteList()) {
                            PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
                            try {
                                writer.write("\t");
                                prereqWriter.write(writer, prereq);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        bw.write(writer.toString());
                    }
                    bw.newLine();
                }
            }
            bw.write("#");
            bw.newLine();
            bw.write("# Point-buy methods");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            for (PointBuyMethod pbm : SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedCDOMObjects(PointBuyMethod.class)) {
                bw.write("METHOD:" + pbm.getDisplayName() + "\t\tPOINTS:" + pbm.getPointFormula());
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writePurchaseModeConfiguration", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writePurchaseModeConfiguration while closing", ex);
            }
        }
    }

    private static BufferedWriter getCustomEquipmentWriter() {
        return CustomData.getWriter(CustomData.customEquipmentFilePath());
    }

    private static String getCustomPath(String type, boolean usePath, String gmName) {
        String aString = "";
        if (usePath) {
            aString = PCGenSettings.getCustomDir();
            aString = aString + File.separator + gmName;
        }
        return aString + File.separator + "custom" + type + ".lst";
    }

    private static String getCustomPath(String type, boolean usePath) {
        return CustomData.getCustomPath(type, usePath, SettingsHandler.getGame().getName());
    }

    private static BufferedWriter getPurchaseModeWriter() {
        return CustomData.getWriter(CustomData.customPurchaseModeFilePath(true, SettingsHandler.getGame().getName()));
    }

    private static BufferedReader getReader(String path) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
        }
        catch (IOException e) {
            Logging.debugPrint("Could not get a reader to read from " + path, e);
            return null;
        }
    }

    private static BufferedWriter getWriter(String path) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
        }
        catch (IOException e) {
            Logging.errorPrint("Could not get a writer to write to " + path + " \nThis means that your custom files won't be written. Please check the path.", e);
            return null;
        }
    }

    private static String customEquipmentFilePath() {
        return CustomData.getCustomPath("Equipment", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomBioSet() {
        BufferedWriter bw = CustomData.getWriter(CustomData.customBioSetFilePath(true));
        if (bw == null) {
            return;
        }
        try {
            bw.write("#");
            bw.newLine();
            bw.write(AUTO_GEN_WARN_LINE_1);
            bw.newLine();
            bw.write(AUTO_GEN_WARN_LINE_2);
            bw.newLine();
            bw.write("#");
            bw.newLine();
            for (Race race : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class)) {
                if (!race.isType("Custom")) continue;
                String[] unp = Globals.getContext().unparseSubtoken(race, "REGION");
                String region = unp == null ? "None" : unp[0];
                String key = race.getKeyName();
                bw.write(Globals.getBioSet().getRacePCCText(region, key));
                bw.newLine();
            }
            bw.newLine();
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomBioSet", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomBioSet while closing", ex);
            }
        }
    }

    private static void writeCustomClasses() {
        CustomData.writeCustomPObjects(CustomData.customClassFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class).iterator());
    }

    private static void writeCustomDeities() {
        CustomData.writeCustomPObjects(CustomData.customDeityFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Deity.class).iterator());
    }

    private static void writeCustomDomains() {
        CustomData.writeCustomPObjects(CustomData.customDomainFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Domain.class).iterator());
    }

    private static void writeCustomAbilities() {
        for (AbilityCategory ac : SettingsHandler.getGame().getAllAbilityCategories()) {
            CustomData.writeCustomPObjects(CustomData.customAbilityFilePath(true), Globals.getContext().getReferenceContext().getManufacturer(Ability.class, ac).getAllObjects().iterator());
        }
    }

    private static void writeCustomFeats() {
        File temp = new File(CustomData.customFeatFilePath(true));
        temp.delete();
    }

    private static void writeCustomHeader(BufferedWriter bw) throws IOException {
        bw.write("#");
        bw.newLine();
        bw.write(AUTO_GEN_WARN_LINE_1);
        bw.newLine();
        bw.write(AUTO_GEN_WARN_LINE_2);
        bw.newLine();
        bw.write("#");
        bw.newLine();
        bw.write("SOURCELONG:Custom\tSOURCESHORT:Custom");
        bw.newLine();
    }

    private static void writeCustomLanguages() {
        CustomData.writeCustomPObjects(CustomData.customLanguageFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Language.class).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomPObjects(String filename, Iterator<? extends PObject> it) {
        BufferedWriter bw = CustomData.getWriter(filename);
        if (bw == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bw);
            while (it.hasNext()) {
                PObject pobj = it.next();
                if (!pobj.isType("Custom")) continue;
                bw.write(pobj.getPCCText());
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomPObjects", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomPObjects while closing", ex);
            }
        }
    }

    private static void writeCustomRaces() {
        CustomData.writeCustomPObjects(CustomData.customRaceFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class).iterator());
    }

    private static void writeCustomSkills() {
        CustomData.writeCustomPObjects(CustomData.customSkillFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class).iterator());
    }

    private static void writeCustomSources() {
        for (Campaign c : Globals.getCampaignList()) {
            if (c.getSafe(StringKey.DESTINATION).length() <= 0) continue;
            CampaignOutput.output(Globals.getContext(), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomSpells() {
        BufferedWriter bw = CustomData.getWriter(CustomData.customSpellFilePath(true));
        if (bw == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bw);
            for (Spell spell : Globals.getSpellMap().values()) {
                if (!spell.isType("Custom")) continue;
                bw.write(spell.getPCCText());
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomSpells", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomSpells while closing", ex);
            }
        }
    }

    private static void writeCustomTemplates() {
        CustomData.writeCustomPObjects(CustomData.customTemplateFilePath(true), Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCTemplate.class).iterator());
    }

    public static void setCustomItemsLoaded(boolean loaded) {
        customItemsLoaded = loaded;
    }
}

