/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.KitApply;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitStat;
import pcgen.core.kit.KitTable;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.facade.core.KitFacade;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public final class Kit
extends PObject
implements Comparable<Object>,
KitFacade {
    private int selectValue = -1;
    private boolean doLevelAbilitiesFlag = true;

    public List<KitStat> getStats() {
        return this.getSafeListFor(ListKey.STAT_LIST);
    }

    public void setSelectValue(int aValue) {
        this.selectValue = aValue;
    }

    public boolean doLevelAbilities() {
        return this.doLevelAbilitiesFlag;
    }

    public void setDoLevelAbilities(boolean yesNo) {
        this.doLevelAbilitiesFlag = yesNo;
    }

    public void addStat(KitStat kitStat) {
        if (kitStat != null) {
            this.addToListFor(ListKey.STAT_LIST, kitStat);
        }
    }

    @Override
    public int compareTo(Object other) {
        Kit oKit = (Kit)other;
        return this.getKeyName().compareToIgnoreCase(oKit.getKeyName());
    }

    public void processKit(PlayerCharacter pc, List<BaseKit> thingsToAdd) {
        this.processKit(pc, thingsToAdd, -1);
    }

    public void processKit(PlayerCharacter pc, List<BaseKit> thingsToAdd, int kitNo) {
        BigDecimal totalCostToBeCharged = this.getTotalCostToBeCharged(pc);
        if (totalCostToBeCharged != null) {
            pc.setGold(pc.getGold().subtract(totalCostToBeCharged));
        }
        for (KitStat kStat : this.getStats()) {
            kStat.apply(pc);
        }
        for (BaseKit bk : thingsToAdd) {
            bk.apply(pc);
        }
        pc.setCalcEquipmentList();
        if (this.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT) {
            pc.addKit(this);
        }
    }

    public int getBuyRate(PlayerCharacter aPC) {
        int buyRate;
        Formula f;
        QualifiedObject<Formula> buy = this.get(ObjectKey.EQUIP_BUY);
        Formula formula = f = buy == null ? null : buy.getObject(aPC, this);
        if (f == null) {
            buyRate = SettingsHandler.getGearTab_BuyRate();
        } else {
            buyRate = f.resolve(aPC, "").intValue();
            if (buyRate == 100) {
                buyRate = SettingsHandler.getGearTab_BuyRate();
            }
        }
        return buyRate;
    }

    public BigDecimal getTotalCost(PlayerCharacter aPC) {
        QualifiedObject<Formula> buy = this.get(ObjectKey.KIT_TOTAL_COST);
        Formula f = buy == null ? null : buy.getObject(aPC, this);
        BigDecimal totalCost = null;
        if (f != null) {
            totalCost = new BigDecimal(f.resolve(aPC, "").doubleValue());
        }
        return totalCost;
    }

    public BigDecimal getTotalCostToBeCharged(PlayerCharacter aPC) {
        BigDecimal theCost = null;
        BigDecimal fixedTotalCost = this.getTotalCost(aPC);
        if (fixedTotalCost != null) {
            fixedTotalCost = fixedTotalCost.setScale(3);
            BigDecimal buyRate = new BigDecimal(SettingsHandler.getGearTab_BuyRate());
            theCost = fixedTotalCost.multiply(buyRate).divide(new BigDecimal(100).setScale(3), RoundingMode.FLOOR);
        }
        return theCost;
    }

    public final boolean isVisible(PlayerCharacter aPC, View v) {
        Visibility kitVisible = this.getSafe(ObjectKey.VISIBILITY);
        if (kitVisible == Visibility.QUALIFY) {
            return this.qualifies(aPC, this);
        }
        return kitVisible.isVisibleTo(v);
    }

    public void testApplyKit(PlayerCharacter aPC, List<BaseKit> thingsToAdd, List<String> warnings) {
        this.testApplyKit(aPC, thingsToAdd, warnings, false);
    }

    public void testApplyKit(PlayerCharacter aPC, List<BaseKit> thingsToAdd, List<String> warnings, boolean subkit) {
        this.selectValue = -1;
        PlayerCharacter tempPC = subkit ? aPC : aPC.clone();
        for (KitStat kStat : this.getStats()) {
            kStat.testApply(this, tempPC, warnings);
        }
        for (BaseKit bk : this.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!PrereqHandler.passesAll(bk.getPrerequisiteList(), tempPC, this) || this.selectValue != -1 && bk.isOptional() && !bk.isOption(tempPC, this.selectValue) || !bk.testApply(this, tempPC, warnings)) continue;
            thingsToAdd.add(bk);
        }
        BigDecimal totalCostToBeCharged = this.getTotalCostToBeCharged(tempPC);
        if (totalCostToBeCharged != null) {
            BigDecimal pcGold = tempPC.getGold();
            if (pcGold.compareTo(BigDecimal.ZERO) >= 0 && pcGold.compareTo(totalCostToBeCharged) < 0) {
                warnings.add("Could not purchase kit. Not enough funds.");
            } else {
                tempPC.setGold(pcGold.subtract(totalCostToBeCharged));
            }
        }
    }

    public String getInfo(PlayerCharacter aPC) {
        StringBuilder info = new StringBuilder(255);
        info.append("<html>");
        info.append("<b><font size=+1>");
        info.append(OutputNameFormatting.piString(this, false));
        info.append("</font></b><br>\n");
        String aString = this.getPreReqHTMLStrings(aPC);
        if (aString.length() != 0) {
            info.append("  <b>Requirements</b>: ").append(aString);
        }
        ArrayList<BaseKit> sortedObjects = new ArrayList<BaseKit>();
        sortedObjects.addAll(this.getSafeListFor(ListKey.KIT_TASKS));
        Collections.sort(sortedObjects, new ObjectTypeComparator());
        String lastObjectName = "";
        for (BaseKit bk : sortedObjects) {
            String objName = bk.getObjectName();
            if (!objName.equals(lastObjectName)) {
                if (!"".equals(lastObjectName)) {
                    info.append("; ");
                }
                info.append("  <b>" + objName + "</b>: ");
                lastObjectName = objName;
            } else {
                info.append(", ");
            }
            info.append(bk.toString());
        }
        info.append("  <b>Source</b>: ").append(SourceFormat.getFormattedString(this, Globals.getSourceDisplay(), true));
        info.append("</html>");
        return info.toString();
    }

    private String getPreReqHTMLStrings(PlayerCharacter aPC) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(aPC, this, this.getPrerequisiteList(), false);
    }

    public static void applyKit(Kit aKit, PlayerCharacter aPC) {
        if (aKit == null) {
            return;
        }
        if (aKit.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT && aPC.containsKit(aKit)) {
            return;
        }
        ArrayList<BaseKit> thingsToAdd = new ArrayList<BaseKit>();
        ArrayList<String> warnings = new ArrayList<String>();
        aKit.testApplyKit(aPC, thingsToAdd, warnings);
        if (Logging.isLoggable(Logging.WARNING) && warnings.size() != 0) {
            Logging.log(Logging.WARNING, "The following warnings were encountered when applying the kit " + aKit.getKeyName());
            for (String string : warnings) {
                Logging.log(Logging.WARNING, "  " + string);
            }
        }
        aKit.processKit(aPC, thingsToAdd, 0);
    }

    public KitTable getTable(String name) {
        return this.get(MapKey.KIT_TABLE, name);
    }

    public KitTable addTable(KitTable table) {
        return this.addToMapFor(MapKey.KIT_TABLE, table.getTableName(), table);
    }

    @Override
    public String getDisplayType() {
        List<Type> trueTypeList = this.getTrueTypeList(true);
        return StringUtil.join(trueTypeList, (String)".");
    }

    @Override
    public boolean isPermanent() {
        return this.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT;
    }

    private static class ObjectTypeComparator
    implements Comparator<BaseKit> {
        private ObjectTypeComparator() {
        }

        @Override
        public int compare(BaseKit bk1, BaseKit bk2) {
            String name1 = bk1.getObjectName();
            String name2 = bk2.getObjectName();
            return name1.compareTo(name2);
        }
    }
}

