/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.facade.core.TemplateFacade;
import pcgen.util.enumeration.View;

public final class PCTemplate
extends PObject
implements TemplateFacade,
ChooseDriver {
    public Integer getCR(int level, int hitdice) {
        Integer localCR = this.getSafe(ObjectKey.CR_MODIFIER).intValue();
        for (PCTemplate pct : this.getConditionalTemplates(level, hitdice)) {
            localCR = localCR + pct.getSafe(ObjectKey.CR_MODIFIER).intValue();
        }
        return localCR;
    }

    public boolean isRemovable() {
        boolean result = false;
        if (this.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) {
            result = this.getSafe(ObjectKey.REMOVABLE);
        }
        return result;
    }

    public List<PCTemplate> getConditionalTemplates(int totalLevels, int totalHitDice) {
        ArrayList<PCTemplate> returnList = new ArrayList<PCTemplate>();
        for (PCTemplate rlt : this.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate lt : rlt.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                if (lt.get(IntegerKey.LEVEL) > totalLevels) continue;
                returnList.add(lt);
            }
        }
        for (PCTemplate lt : this.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            if (lt.get(IntegerKey.LEVEL) > totalLevels) continue;
            returnList.add(lt);
        }
        for (PCTemplate lt : this.getSafeListFor(ListKey.HD_TEMPLATES)) {
            if (lt.get(IntegerKey.HD_MAX) < totalHitDice || lt.get(IntegerKey.HD_MIN) > totalHitDice) continue;
            returnList.add(lt);
        }
        return returnList;
    }

    @Override
    public List<BonusObj> getRawBonusList(PlayerCharacter pc) {
        ArrayList<BonusObj> list = new ArrayList<BonusObj>(super.getRawBonusList(pc));
        for (PCTemplate rlt : this.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate lt : rlt.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                list.addAll(lt.getRawBonusList(pc));
            }
        }
        for (PCTemplate lt : this.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            list.addAll(lt.getRawBonusList(pc));
        }
        for (PCTemplate lt : this.getSafeListFor(ListKey.HD_TEMPLATES)) {
            list.addAll(lt.getRawBonusList(pc));
        }
        return list;
    }

    @Override
    public ChooseInformation<?> getChooseInfo() {
        return this.get(ObjectKey.CHOOSE_INFO);
    }

    @Override
    public Formula getSelectFormula() {
        return this.getSafe(FormulaKey.SELECT);
    }

    @Override
    public List<ChooseSelectionActor<?>> getActors() {
        return this.getListFor(ListKey.NEW_CHOOSE_ACTOR);
    }

    @Override
    public String getFormulaSource() {
        return this.getKeyName();
    }

    @Override
    public Formula getNumChoices() {
        return this.getSafe(FormulaKey.NUMCHOICES);
    }
}

