/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.HiddenTypeFacet;
import pcgen.core.Globals;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.utils.KeyedListContainer;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.system.PCGenSettings;

public class PObject
extends CDOMObject
implements Cloneable,
Serializable,
Comparable<Object>,
KeyedListContainer,
QualifyingObject {
    private HiddenTypeFacet hiddenTypeFacet = FacetLibrary.getFacet(HiddenTypeFacet.class);
    private static final long serialVersionUID = 1L;
    private final Class<?> myClass = this.getClass();

    @Override
    public PObject clone() throws CloneNotSupportedException {
        return (PObject)super.clone();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj != null) {
            return this.getKeyName().compareToIgnoreCase(((PObject)obj).getKeyName());
        }
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof PObject && this.getKeyName().equalsIgnoreCase(((PObject)obj).getKeyName());
    }

    @Override
    public void setName(String aString) {
        if (!aString.endsWith(".MOD")) {
            super.setName(aString);
            this.put(StringKey.KEY_NAME, aString);
        }
    }

    public final String getOutputName() {
        return OutputNameFormatting.getOutputName(this);
    }

    public String getType() {
        return StringUtil.join(this.getTrueTypeList(false), (String)".");
    }

    public final List<Type> getTrueTypeList(boolean visibleOnly) {
        List<Type> ret = this.getSafeListFor(ListKey.TYPE);
        if (visibleOnly) {
            Iterator<Type> it = ret.iterator();
            while (it.hasNext()) {
                DataSetID id = Globals.getContext().getDataSetID();
                if (!this.hiddenTypeFacet.contains(id, this.myClass, it.next())) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableList(ret);
    }

    public String getClassType() {
        FactKey fk = FactKey.valueOf("ClassType");
        return (String)this.getResolved(fk);
    }

    @Override
    public boolean isType(String aType) {
        if (aType.length() == 0) {
            return false;
        }
        String myType = aType.charAt(0) == '!' ? aType.substring(1).toUpperCase() : (aType.startsWith("TYPE=") || aType.startsWith("TYPE.") ? aType.substring(5).toUpperCase() : aType.toUpperCase());
        StringTokenizer tok = new StringTokenizer(myType, ".");
        while (tok.hasMoreTokens()) {
            if (this.containsInList(ListKey.TYPE, Type.getConstant(tok.nextToken()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (PCGenSettings.OPTIONS_CONTEXT.getBoolean("showOutputNameForOtherItems", false)) {
            return this.getOutputName();
        }
        return this.getDisplayName();
    }

    public boolean isNamePI() {
        return this.getSafe(ObjectKey.NAME_PI);
    }

    public String getPCCText() {
        StringBuilder txt = new StringBuilder(200);
        txt.append(this.getDisplayName());
        txt.append("\t");
        txt.append((CharSequence)StringUtil.joinToStringBuilder(Globals.getContext().unparse(this), (String)"\t"));
        txt.append("\t");
        txt.append(PrerequisiteWriter.prereqsToString(this));
        return txt.toString();
    }

    public String getSource() {
        return SourceFormat.getFormattedString(this, Globals.getSourceDisplay(), true);
    }

    public String getSourceForNodeDisplay() {
        return SourceFormat.getFormattedString(this, SourceFormat.LONG, false);
    }
}

