/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.identifier.SpellSchool;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpellProhibitor;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;

public class SpellCountCalc {
    public static int memorizedSpellForLevelBook(PlayerCharacter pc, PCClass cl, int aLevel, String bookName) {
        int m = 0;
        List<CharacterSpell> aList = pc.getCharacterSpells(cl, null, bookName, aLevel);
        if (aList.isEmpty()) {
            return m;
        }
        for (CharacterSpell cs : aList) {
            m += cs.getSpellInfoFor(bookName, aLevel).getTimes();
        }
        return m;
    }

    public static int memorizedSpecialtiesForLevelBook(int aLevel, String bookName, PlayerCharacter pc, PCClass cl) {
        int m = 0;
        List<CharacterSpell> aList = pc.getCharacterSpells(cl, null, bookName, aLevel);
        if (aList.isEmpty()) {
            return m;
        }
        for (CharacterSpell cs : aList) {
            if (!cs.isSpecialtySpell(pc)) continue;
            m += cs.getSpellInfoFor(bookName, aLevel).getTimes();
        }
        return m;
    }

    public static boolean isSpecialtySpell(PlayerCharacter pc, PCClass cl, Spell aSpell) {
        String specialty = pc.getAssoc(cl, AssociationKey.SPECIALTY);
        if (specialty != null) {
            SpellSchool ss = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SpellSchool.class, specialty);
            return ss != null && aSpell.containsInList(ListKey.SPELL_SCHOOL, ss) || aSpell.containsInList(ListKey.SPELL_SUBSCHOOL, specialty) || aSpell.containsInList(ListKey.SPELL_DESCRIPTOR, specialty);
        }
        return false;
    }

    public static boolean isProhibited(Spell aSpell, PCClass cl, PlayerCharacter aPC) {
        if (!aSpell.qualifies(aPC, aSpell)) {
            return true;
        }
        for (SpellProhibitor spellProhibitor : aPC.getProhibitedSchools(cl)) {
            if (!spellProhibitor.isProhibited(aSpell, aPC, cl)) continue;
            return true;
        }
        return false;
    }
}

