/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.core.prereq.PreMult;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class PrerequisiteTestFactory
implements PluginLoader {
    private static PrerequisiteTestFactory instance = null;
    private static Map<String, PrerequisiteTest> testLookup = new HashMap<String, PrerequisiteTest>();

    public static PrerequisiteTestFactory getInstance() {
        if (instance == null) {
            instance = new PrerequisiteTestFactory();
        }
        return instance;
    }

    private PrerequisiteTestFactory() {
    }

    public static void register(PrerequisiteTest testClass) {
        String kindHandled = testClass.kindHandled();
        PrerequisiteTest test = testLookup.get(kindHandled);
        if (test != null) {
            Logging.errorPrint(LanguageBundle.getFormattedString("PrerequisiteTestFactory.error.already_registered", testClass.getClass().getName(), kindHandled, test.getClass().getName()));
        }
        testLookup.put(kindHandled.toUpperCase(), testClass);
    }

    public PrerequisiteTest getTest(String kind) {
        PrerequisiteTest test;
        if (kind == null) {
            test = new PreMult();
        } else {
            test = testLookup.get(kind.toUpperCase());
            if (test == null) {
                Logging.errorPrintLocalised("PrerequisiteTestFactory.error.cannot_find_test", kind);
            }
        }
        return test;
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        PrerequisiteTestFactory.register((PrerequisiteTest)clazz.newInstance());
    }

    @Override
    public Class<?>[] getPluginClasses() {
        return new Class[]{PrerequisiteTest.class};
    }
}

