/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import gmgen.GMGenSystem;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.dialog.PreferencesDialog;
import pcgen.gui2.facade.GMGenMessageHandler;
import pcgen.gui2.plaf.MacGUIHandler;
import pcgen.pluginmgr.PluginManager;
import pcgen.system.Main;

public final class PCGenUIManager {
    private static PCGenFrame pcgenFrame = null;

    private PCGenUIManager() {
    }

    public static void refreshUITree() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    private boolean checkBounds() {
        return false;
    }

    public static void initializeGUI() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            MacGUIHandler.initialize();
        }
        pcgenFrame = new PCGenFrame();
        PluginManager pluginMgr = PluginManager.getInstance();
        GMGenMessageHandler handler = new GMGenMessageHandler(pcgenFrame, pluginMgr.getPostbox());
        pluginMgr.addMember(handler);
    }

    public static void startGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                pcgenFrame.startPCGenFrame();
            }
        });
    }

    public static void displayPreferencesDialog() {
        PreferencesDialog.show(pcgenFrame);
    }

    public static void displayAboutDialog() {
        pcgenFrame.showAboutDialog();
    }

    public static void closePCGen() {
        if (!pcgenFrame.closeAllCharacters()) {
            return;
        }
        pcgenFrame.dispose();
        Main.shutdown();
    }

    public static void displayGmGen() {
        if (GMGenSystem.inst == null) {
            new GMGenSystem();
        } else {
            GMGenSystem.inst.setVisible(true);
        }
    }
}

