/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.inst.ObjectCache;
import pcgen.gui2.converter.PCGenDataConvert;
import pcgen.gui2.converter.event.ProgressEvent;
import pcgen.gui2.converter.event.ProgressListener;
import pcgen.gui2.converter.event.TaskStrategyListener;
import pcgen.gui2.converter.event.TaskStrategyMessage;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.tools.CursorControlUtilities;
import pcgen.gui2.tools.Utility;

public class ConvertPanel
extends JPanel {
    private static final long serialVersionUID = 1686411319132380251L;
    private final JPanel basePanel = new JPanel();
    private final JButton finishButton;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JButton cancelButton;
    private final CDOMObject properties;
    private final ProgressListener pl;
    private final List<ConvertSubPanel> queue;
    private int currentPanel = -1;
    private final JLabel statusLabel = new JLabel();

    public ConvertPanel(List<ConvertSubPanel> bq) {
        super(new BorderLayout());
        TaskStrategyListener tsl = new TaskStrategyListener(){
            private String status;
            private long time;

            @Override
            public void processMessage(Object owner, String string) {
                JOptionPane.showMessageDialog(null, string);
            }

            @Override
            public void processStatus(Object source, String string) {
                this.status = string;
                ConvertPanel.this.statusLabel.setText(string);
            }

            @Override
            public void processActiveItem(Object source, String string) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.time > 100L) {
                    ConvertPanel.this.statusLabel.setText(this.status + " [" + string + "]");
                    this.time = currentTime;
                }
            }
        };
        TaskStrategyMessage.addTaskStrategyListener(tsl);
        this.properties = new ObjectCache();
        Box buttonBox = Box.createHorizontalBox();
        this.prevButton = new JButton("< Previous");
        this.prevButton.setMnemonic('P');
        this.prevButton.addActionListener(new PreviousButtonListener());
        this.prevButton.setEnabled(false);
        buttonBox.add(this.prevButton);
        this.nextButton = new JButton("Next >");
        this.nextButton.setMnemonic('N');
        this.pl = new ProgressListener(){

            @Override
            public void progressAllowed(ProgressEvent pe) {
                if (pe.getID() == 2) {
                    ConvertPanel.this.proceedToNextPanel();
                } else {
                    ConvertPanel.this.nextButton.setEnabled(true);
                }
            }

            @Override
            public void progressNotAllowed(ProgressEvent pe) {
                ConvertPanel.this.nextButton.setEnabled(false);
            }
        };
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConvertPanel.this.proceedToNextPanel();
            }
        });
        buttonBox.add(this.nextButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConvertPanel.this.checkExit();
            }
        });
        buttonBox.add(this.cancelButton);
        this.finishButton = new JButton("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PCGenDataConvert.savePrefs();
                System.exit(0);
            }
        });
        this.finishButton.setVisible(false);
        buttonBox.add(this.finishButton);
        this.basePanel.setPreferredSize(new Dimension(800, 500));
        JScrollPane jsp = new JScrollPane(this.basePanel);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(20);
        this.add(jsp);
        JPanel buttonLayout = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 1, 1, 1.0, 0.0, 2, 17);
        gbc.insets = new Insets(0, 10, 5, 10);
        buttonLayout.add((Component)this.statusLabel, gbc);
        Utility.buildRelativeConstraints(gbc, 0, 1, 0.0, 0.0, 0, 13);
        buttonLayout.add((Component)buttonBox, gbc);
        this.add((Component)buttonLayout, "South");
        this.queue = bq;
        this.runNextPanel();
    }

    private void proceedToNextPanel() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                CursorControlUtilities.startWaitCursor(ConvertPanel.this.basePanel);
                ConvertPanel.this.runNextPanel();
                CursorControlUtilities.stopWaitCursor(ConvertPanel.this.basePanel);
            }
        });
        t.start();
    }

    public void prepare(ConvertSubPanel panel, boolean allowPrev) {
        this.setButtonVisibility(panel.isLast(), allowPrev);
        panel.addProgressListener(this.pl);
        panel.performAnalysis(this.properties);
    }

    private void setButtonVisibility(boolean displayingLast, boolean allowPrev) {
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(allowPrev);
        this.cancelButton.setVisible(true);
    }

    private void showFinishButton() {
        this.finishButton.setVisible(true);
        this.cancelButton.setVisible(false);
    }

    public void checkExit() {
        int response = JOptionPane.showConfirmDialog(this, "Are you sure you wish to cancel and exit?", "Confirm Exit", 2);
        if (response == 0) {
            PCGenDataConvert.savePrefs();
            System.exit(0);
        }
    }

    private void runNextPanel() {
        ConvertSubPanel nextpanel = null;
        do {
            boolean allowPrev = false;
            if (this.currentPanel >= 0 && this.currentPanel < this.queue.size()) {
                allowPrev = this.queue.get(this.currentPanel).returnAllowed();
            }
            ++this.currentPanel;
            if (this.currentPanel < this.queue.size()) {
                nextpanel = this.queue.get(this.currentPanel);
                this.prepare(nextpanel, allowPrev);
                this.basePanel.removeAll();
                nextpanel.setupDisplay(this.basePanel, this.properties);
                this.basePanel.repaint();
                continue;
            }
            nextpanel = null;
            this.showFinishButton();
        } while (nextpanel != null && nextpanel.autoAdvance(this.properties));
    }

    public Component getStatusField() {
        return this.statusLabel;
    }

    public class PreviousButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            CursorControlUtilities.startWaitCursor(ConvertPanel.this.basePanel);
            ConvertSubPanel prevpanel = null;
            do {
                ConvertPanel.this.currentPanel--;
                if (ConvertPanel.this.currentPanel >= 0 && ConvertPanel.this.currentPanel < ConvertPanel.this.queue.size()) {
                    prevpanel = (ConvertSubPanel)ConvertPanel.this.queue.get(ConvertPanel.this.currentPanel);
                    boolean allowPrev = false;
                    if (ConvertPanel.this.currentPanel > 0) {
                        allowPrev = ((ConvertSubPanel)ConvertPanel.this.queue.get(ConvertPanel.this.currentPanel - 1)).returnAllowed();
                    }
                    ConvertPanel.this.prepare(prevpanel, allowPrev);
                    ConvertPanel.this.basePanel.removeAll();
                    prevpanel.setupDisplay(ConvertPanel.this.basePanel, ConvertPanel.this.properties);
                    ConvertPanel.this.basePanel.repaint();
                    continue;
                }
                prevpanel = null;
            } while (prevpanel != null && prevpanel.autoAdvance(ConvertPanel.this.properties));
            CursorControlUtilities.stopWaitCursor(ConvertPanel.this.basePanel);
        }
    }
}

