/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.persistence.CampaignFileLoader;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class GameModePanel
extends ConvertSubPanel {
    JComboBoxEx gameModeCombo;
    private SpringLayout layout = new SpringLayout();
    private final CampaignFileLoader campaignFileLoader;

    public GameModePanel(CampaignFileLoader campaignFileLoader) {
        this.campaignFileLoader = campaignFileLoader;
    }

    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean returnAllowed() {
        return true;
    }

    @Override
    public boolean performAnalysis(CDOMObject pc) {
        GameMode gameMode;
        File sourceDir = pc.get(ObjectKey.DIRECTORY);
        String name = sourceDir.getAbsolutePath();
        if (!(name.equals(ConfigurationSettings.getPccFilesDir()) || name.equals(PCGenSettings.getVendorDataDir()) || name.equals(PCGenSettings.getHomebrewDataDir()))) {
            Logging.log(Logging.INFO, "Loading campaigns from " + sourceDir);
            Globals.clearCampaignsForRefresh();
            this.campaignFileLoader.setAlternateSourceFolder(sourceDir);
            this.campaignFileLoader.execute();
        }
        if ((gameMode = pc.get(ObjectKey.GAME_MODE)) != null) {
            SettingsHandler.setGame(gameMode.getName());
        }
        Globals.sortPObjectListByName(Globals.getCampaignList());
        Globals.createEmptyRace();
        return this.saveGameMode(pc);
    }

    private boolean saveGameMode(CDOMObject pc) {
        boolean advance;
        boolean bl = advance = pc.get(ObjectKey.GAME_MODE) != null;
        if (advance) {
            this.fireProgressEvent(0);
        } else {
            this.fireProgressEvent(1);
        }
        return advance;
    }

    private void getSelection(CDOMObject pc) {
        GameMode gameMode = (GameMode)this.gameModeCombo.getSelectedItem();
        pc.put(ObjectKey.GAME_MODE, gameMode);
        PCGenSettings context = PCGenSettings.getInstance();
        context.setProperty("pcgen.convert.gamemode", gameMode.getName());
    }

    @Override
    public void setupDisplay(JPanel panel, final CDOMObject pc) {
        panel.setLayout(this.layout);
        JLabel introLabel = new JLabel("Please select the Game Mode to Convert:");
        panel.add(introLabel);
        this.layout.putConstraint("North", (Component)introLabel, 50, "North", (Component)panel);
        this.layout.putConstraint("West", (Component)introLabel, 25, "West", (Component)panel);
        List<GameMode> games = SystemCollections.getUnmodifiableGameModeList();
        this.gameModeCombo = new JComboBoxEx(games.toArray());
        this.gameModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameModePanel.this.getSelection(pc);
                GameModePanel.this.saveGameMode(pc);
            }
        });
        PCGenSettings context = PCGenSettings.getInstance();
        SettingsHandler.setGame(context.initProperty("pcgen.convert.gamemode", SettingsHandler.getGame().getName()));
        GameMode currGame = SettingsHandler.getGame();
        if (pc.get(ObjectKey.GAME_MODE) != null) {
            currGame = pc.get(ObjectKey.GAME_MODE);
        }
        this.gameModeCombo.setSelectedItem(currGame);
        this.getSelection(pc);
        this.saveGameMode(pc);
        panel.add(this.gameModeCombo);
        this.layout.putConstraint("North", (Component)this.gameModeCombo, 20, "South", (Component)introLabel);
        this.layout.putConstraint("West", (Component)this.gameModeCombo, 25, "West", (Component)panel);
    }
}

