/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import pcgen.cdom.enumeration.Destination;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.InstallableCampaign;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.dialog.DIWarningDialog;
import pcgen.gui2.tools.CommonMenuText;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.InstallLoader;
import pcgen.system.ConfigurationSettings;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class DataInstaller
extends JFrame {
    private static final long serialVersionUID = -7429544164441235718L;
    private static final String OUTPUTSHEETS_FOLDER = "outputsheets/";
    private static final String DATA_FOLDER = "data/";
    private static final String TITLE = LanguageBundle.getString("in_dataInstaller");
    private JTextField dataSetSel;
    private JButton selectButton;
    private JEditorPane dataSetDetails;
    private JRadioButton locDataButton;
    private JRadioButton locVendorDataButton;
    private JRadioButton locHomebrewDataButton;
    private JButton installButton;
    private JButton closeButton;
    private ActionListener listener = new InstallerButtonListener();
    private InstallableCampaign campaign;
    private File currDataSet;
    private File currFolder = new File(System.getProperty("user.dir"));

    public DataInstaller() {
        this.initComponents();
        this.setIconImage(Icons.PCGenApp.getImageIcon().getImage());
        Utility.centerFrame(this, false);
    }

    private boolean checkNonStandardOK(Collection<String> files) {
        ArrayList<String> nonStandardFiles = new ArrayList<String>();
        for (String filename : files) {
            if (filename.toLowerCase().startsWith(DATA_FOLDER) || filename.toLowerCase().startsWith(OUTPUTSHEETS_FOLDER)) continue;
            nonStandardFiles.add(filename);
        }
        if (!nonStandardFiles.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (String filename : nonStandardFiles) {
                msg.append(' ').append(filename).append("\n");
            }
            DIWarningDialog dialog = new DIWarningDialog((Frame)this, msg.toString(), LanguageBundle.getFormattedString("in_diNonStandardFiles", new Object[0]));
            dialog.setVisible(true);
            int result = dialog.getResponse();
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                for (String filename : nonStandardFiles) {
                    files.remove(filename);
                }
            }
        }
        return true;
    }

    private boolean checkOverwriteOK(Collection<String> files, File destDir) {
        ArrayList<String> existingFiles = new ArrayList<String>();
        ArrayList<String> existingFilesCorr = new ArrayList<String>();
        for (String filename : files) {
            String correctedFilename = this.correctFileName(destDir, filename);
            if (!new File(correctedFilename).exists()) continue;
            existingFiles.add(filename);
            existingFilesCorr.add(correctedFilename);
        }
        if (!existingFiles.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (String filename : existingFilesCorr) {
                msg.append(' ').append(filename).append("\n");
            }
            DIWarningDialog dialog = new DIWarningDialog((Frame)this, msg.toString(), LanguageBundle.getFormattedString("in_diOverwriteFiles", new Object[0]));
            dialog.setVisible(true);
            int result = dialog.getResponse();
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                for (String filename : existingFiles) {
                    files.remove(filename);
                }
            }
        }
        return true;
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private String correctFileName(File destDir, String fileName) {
        if (fileName.toLowerCase().startsWith(DATA_FOLDER)) {
            fileName = destDir.getAbsolutePath() + fileName.substring(4);
        } else if (fileName.toLowerCase().startsWith(OUTPUTSHEETS_FOLDER)) {
            fileName = new File(ConfigurationSettings.getOutputSheetsDir()).getAbsolutePath() + fileName.substring(12);
        }
        return fileName;
    }

    private boolean createDirectories(Iterable<String> directories, File destDir) {
        for (String dirname : directories) {
            String corrDirname = this.correctFileName(destDir, dirname);
            File dir = new File(corrDirname);
            if (dir.exists()) continue;
            Logging.log(Logging.INFO, "Creating directory: " + dir);
            if (dir.mkdirs()) continue;
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diDirNotCreated", dir.getAbsoluteFile()), TITLE, MessageType.ERROR);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createFiles(File dataSet, File destDir, Iterable<String> files) {
        String corrFilename = "";
        try (ZipFile in = new ZipFile(dataSet);){
            for (String filename : files) {
                ZipEntry entry = in.getEntry(filename);
                corrFilename = this.correctFileName(destDir, filename);
                if (Logging.isDebugMode()) {
                    Logging.debugPrint("Extracting file: " + filename + " to " + corrFilename);
                }
                this.copyInputStream(in.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(corrFilename)));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logging.errorPrint("Failed to read data set " + dataSet + " or write file " + corrFilename + " due to ", e);
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diWriteFail", corrFilename), TITLE, MessageType.ERROR);
            return false;
        }
    }

    private void initComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        GridBagLayout gridbag = new GridBagLayout();
        this.setTitle(TITLE);
        this.setLayout(gridbag);
        Utility.buildConstraints(gbc, 0, 0, 1, 1, 0.0, 0.0);
        JLabel dataSetLabel = new JLabel(LanguageBundle.getString("in_diDataSet"), 4);
        gridbag.setConstraints(dataSetLabel, gbc);
        this.add((Component)dataSetLabel, gbc);
        Utility.buildConstraints(gbc, 1, 0, 2, 1, 1.0, 0.0);
        this.dataSetSel = new JTextField("", 7);
        this.dataSetSel.setEditable(false);
        gridbag.setConstraints(this.dataSetSel, gbc);
        this.add((Component)this.dataSetSel, gbc);
        Utility.buildConstraints(gbc, 3, 0, 1, 1, 0.0, 0.0);
        gbc.fill = 0;
        this.selectButton = new JButton();
        CommonMenuText.name(this.selectButton, "select", new Object[0]);
        gridbag.setConstraints(this.selectButton, gbc);
        this.add((Component)this.selectButton, gbc);
        this.selectButton.addActionListener(this.listener);
        Utility.buildConstraints(gbc, 0, 1, 4, 1, 1.0, 1.0);
        this.dataSetDetails = new JEditorPane("text/html", "<html></html>");
        this.dataSetDetails.setPreferredSize(new Dimension(400, 200));
        this.dataSetDetails.setEditable(false);
        this.dataSetDetails.setBackground(this.getBackground());
        gbc.fill = 1;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.dataSetDetails);
        gridbag.setConstraints(jScrollPane, gbc);
        this.add((Component)jScrollPane, gbc);
        Utility.buildConstraints(gbc, 0, 2, 1, 1, 0.0, 0.0);
        gbc.fill = 2;
        JLabel locLabel = new JLabel(LanguageBundle.getString("in_diLocation"), 4);
        gridbag.setConstraints(locLabel, gbc);
        this.add((Component)locLabel, gbc);
        ButtonGroup exclusiveGroup = new ButtonGroup();
        this.locDataButton = new JRadioButton(LanguageBundle.getString("in_diData"));
        this.locDataButton.setToolTipText(LanguageBundle.getString("in_diData_tip"));
        exclusiveGroup.add(this.locDataButton);
        this.locVendorDataButton = new JRadioButton(LanguageBundle.getString("in_diVendorData"));
        this.locVendorDataButton.setToolTipText(LanguageBundle.getString("in_diVendorData_tip"));
        exclusiveGroup.add(this.locVendorDataButton);
        this.locHomebrewDataButton = new JRadioButton(LanguageBundle.getString("in_diHomebrewData"));
        this.locHomebrewDataButton.setToolTipText(LanguageBundle.getString("in_diHomebrewData_tip"));
        exclusiveGroup.add(this.locHomebrewDataButton);
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.locDataButton);
        optionsPanel.add(this.locVendorDataButton);
        optionsPanel.add(this.locHomebrewDataButton);
        Utility.buildConstraints(gbc, 1, 2, 3, 1, 0.0, 0.0);
        gridbag.setConstraints(optionsPanel, gbc);
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)optionsPanel, gbc);
        this.installButton = new JButton();
        CommonMenuText.name(this.installButton, "diInstall", new Object[0]);
        this.installButton.addActionListener(this.listener);
        this.closeButton = new JButton();
        CommonMenuText.name(this.closeButton, "close", new Object[0]);
        this.closeButton.addActionListener(this.listener);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.installButton);
        buttonsPanel.add(this.closeButton);
        Utility.buildConstraints(gbc, 2, 3, 2, 1, 0.0, 0.0);
        gridbag.setConstraints(buttonsPanel, gbc);
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)buttonsPanel, gbc);
        this.pack();
    }

    private boolean populateFileAndDirLists(File dataSet, Collection<String> directories, Collection<String> files) {
        try (ZipFile in = new ZipFile(dataSet);){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    directories.add(entry.getName());
                    continue;
                }
                if (entry.getName().equalsIgnoreCase("install.lst")) continue;
                files.add(entry.getName());
            }
            in.close();
        }
        catch (IOException e) {
            Logging.errorPrint("Failed to read data set " + dataSet + " due to ", e);
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diBadDataSet", dataSet), TITLE, MessageType.ERROR);
            return false;
        }
        return true;
    }

    private final class InstallerButtonListener
    implements ActionListener {
        private InstallerButtonListener() {
        }

        private Destination getSelectedDestination() {
            if (DataInstaller.this.locDataButton.isSelected()) {
                return Destination.DATA;
            }
            if (DataInstaller.this.locVendorDataButton.isSelected()) {
                return Destination.VENDORDATA;
            }
            if (DataInstaller.this.locHomebrewDataButton.isSelected()) {
                return Destination.HOMEBREWDATA;
            }
            return null;
        }

        private boolean installDataSource(File dataSet, Destination dest) {
            File destDir;
            if (dataSet == null) {
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diDataSetNotSelected", new Object[0]), TITLE, MessageType.ERROR);
                return false;
            }
            if (dest == null) {
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diDataFolderNotSelected", new Object[0]), TITLE, MessageType.ERROR);
                return false;
            }
            switch (dest) {
                case VENDORDATA: {
                    destDir = new File(PCGenSettings.getVendorDataDir());
                    break;
                }
                case HOMEBREWDATA: {
                    destDir = new File(PCGenSettings.getHomebrewDataDir());
                    break;
                }
                default: {
                    destDir = new File(ConfigurationSettings.getPccFilesDir());
                }
            }
            if (!destDir.exists()) {
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diDataFolderNotExist", destDir.getAbsoluteFile()), TITLE, MessageType.ERROR);
                return false;
            }
            ArrayList directories = new ArrayList();
            ArrayList files = new ArrayList();
            if (!DataInstaller.this.populateFileAndDirLists(dataSet, directories, files)) {
                return false;
            }
            if (!DataInstaller.this.checkNonStandardOK(files)) {
                return false;
            }
            if (!DataInstaller.this.checkOverwriteOK(files, destDir)) {
                return false;
            }
            if (!DataInstaller.this.createDirectories(directories, destDir)) {
                return false;
            }
            return DataInstaller.this.createFiles(dataSet, destDir, files);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton source = (JButton)actionEvent.getSource();
            if (source != null) {
                if (source.equals(DataInstaller.this.closeButton)) {
                    DataInstaller.this.setVisible(false);
                    DataInstaller.this.dispose();
                } else if (source.equals(DataInstaller.this.selectButton)) {
                    JFileChooser chooser = new JFileChooser(DataInstaller.this.currFolder);
                    chooser.setDialogTitle(LanguageBundle.getString("in_diChooserTitle"));
                    chooser.setFileFilter(new DataPackFilter());
                    int result = chooser.showOpenDialog(DataInstaller.this);
                    if (result != 0) {
                        return;
                    }
                    File dataset = chooser.getSelectedFile();
                    DataInstaller.this.currFolder = dataset.getParentFile();
                    this.readDataSet(dataset);
                } else if (source.equals(DataInstaller.this.installButton) && this.installDataSource(DataInstaller.this.currDataSet, this.getSelectedDestination())) {
                    ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diInstalled", DataInstaller.this.campaign.getDisplayName()), TITLE, MessageType.INFORMATION);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readDataSet(File dataSet) {
            try (ZipFile in = new ZipFile(dataSet);){
                String line;
                ZipEntry installEntry = null;
                Enumeration<? extends ZipEntry> entries = in.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equalsIgnoreCase("install.lst")) continue;
                    installEntry = entry;
                    break;
                }
                if (installEntry == null) {
                    Logging.errorPrint("File " + dataSet + " is not a valid datsset - no Install.lst file");
                    ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diNoInstallFile", dataSet.getName()), TITLE, MessageType.WARNING);
                    in.close();
                    boolean entry = false;
                    return entry;
                }
                InputStream inStream = in.getInputStream(installEntry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                StringBuilder installInfo = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    installInfo.append(line).append("\n");
                }
                InstallLoader loader = new InstallLoader();
                loader.loadLstString(null, dataSet.toURI(), installInfo.toString());
                DataInstaller.this.campaign = loader.getCampaign();
                in.close();
            }
            catch (IOException e) {
                Logging.errorPrint("Failed to read data set " + dataSet + " due to ", e);
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diBadDataSet", dataSet), TITLE, MessageType.ERROR);
                return false;
            }
            catch (PersistenceLayerException e) {
                Logging.errorPrint("Failed to parse data set " + dataSet + " due to ", e);
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diBadDataSet", dataSet), TITLE, MessageType.ERROR);
                return false;
            }
            if (DataInstaller.this.campaign.getSafe(StringKey.MINDEVVER) != null && !CoreUtility.isPriorToCurrent(DataInstaller.this.campaign.getSafe(StringKey.MINDEVVER)) && CoreUtility.isCurrMinorVer(DataInstaller.this.campaign.getSafe(StringKey.MINDEVVER))) {
                Logging.errorPrint("Dataset " + DataInstaller.this.campaign.getDisplayName() + " needs at least PCGen version " + DataInstaller.this.campaign.getSafe(StringKey.MINDEVVER) + " to run. It could not be installed.");
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diVersionTooOldDev", DataInstaller.this.campaign.getSafe(StringKey.MINDEVVER), DataInstaller.this.campaign.getSafe(StringKey.MINVER)), TITLE, MessageType.WARNING);
                return false;
            }
            if (DataInstaller.this.campaign.getSafe(StringKey.MINVER) != null && !CoreUtility.isPriorToCurrent(DataInstaller.this.campaign.getSafe(StringKey.MINVER))) {
                Logging.errorPrint("Dataset " + DataInstaller.this.campaign.getDisplayName() + " needs at least PCGen version " + DataInstaller.this.campaign.getSafe(StringKey.MINVER) + " to run. It could not be installed.");
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_diVersionTooOld", DataInstaller.this.campaign.getSafe(StringKey.MINVER)), TITLE, MessageType.WARNING);
                return false;
            }
            DataInstaller.this.dataSetSel.setText(dataSet.getAbsolutePath());
            DataInstaller.this.dataSetDetails.setText(FacadeFactory.getCampaignInfoFactory().getHTMLInfo(DataInstaller.this.campaign));
            if (DataInstaller.this.campaign.get(ObjectKey.DESTINATION) == null) {
                DataInstaller.this.locDataButton.setSelected(false);
                DataInstaller.this.locVendorDataButton.setSelected(false);
                DataInstaller.this.locHomebrewDataButton.setSelected(false);
            } else {
                switch (DataInstaller.this.campaign.get(ObjectKey.DESTINATION)) {
                    case DATA: {
                        DataInstaller.this.locDataButton.setSelected(true);
                        break;
                    }
                    case VENDORDATA: {
                        DataInstaller.this.locVendorDataButton.setSelected(true);
                        break;
                    }
                    case HOMEBREWDATA: {
                        DataInstaller.this.locHomebrewDataButton.setSelected(true);
                        break;
                    }
                }
            }
            DataInstaller.this.currDataSet = dataSet;
            DataInstaller.this.toFront();
            return true;
        }
    }

    private final class DataPackFilter
    extends FileFilter {
        private DataPackFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String nameLc = f.getName().toLowerCase();
            return nameLc.endsWith(".zip") || nameLc.endsWith(".pcz");
        }

        @Override
        public String getDescription() {
            return "Data Sets (*.pcz,*.zip)";
        }
    }
}

