/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.equip;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipModFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.TreeColumnCellRenderer;
import pcgen.system.LanguageBundle;

public class EquipQualifiedTreeCellRenderer
extends TreeColumnCellRenderer {
    private CharacterFacade character;
    private EquipmentFacade equip;

    public EquipQualifiedTreeCellRenderer(CharacterFacade character, EquipmentFacade equip) {
        this.character = character;
        this.equip = equip;
        this.setTextNonSelectionColor(UIPropertyContext.getQualifiedColor());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if ("".equals(obj)) {
            obj = LanguageBundle.getString("in_none");
        }
        super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, focus);
        if (obj instanceof EquipModFacade && !this.character.isQualifiedFor(this.equip, (EquipModFacade)obj)) {
            this.setForeground(UIPropertyContext.getNotQualifiedColor());
        }
        if (obj instanceof InfoFacade && ((InfoFacade)obj).isNamePI()) {
            this.setFont(FontManipulation.bold_italic(this.getFont()));
        } else {
            this.setFont(FontManipulation.plain(this.getFont()));
        }
        return this;
    }
}

