/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.content.CampaignURL;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Status;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CampaignInfoFactory;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.system.LanguageBundle;

public class Gui2CampaignInfoFactory
implements CampaignInfoFactory {
    @Override
    public String getHTMLInfo(CampaignFacade campaign, List<CampaignFacade> testList) {
        PersistenceManager pman = PersistenceManager.getInstance();
        List<URI> oldList = this.setSourcesForPrereqTesting(testList, pman);
        String htmlInfo = this.getHTMLInfo(campaign);
        pman.setChosenCampaignSourcefiles(oldList);
        return htmlInfo;
    }

    private List<URI> setSourcesForPrereqTesting(List<CampaignFacade> testList, PersistenceManager pman) {
        List<URI> oldList = pman.getChosenCampaignSourcefiles();
        ArrayList<URI> uris = new ArrayList<URI>();
        for (CampaignFacade campaignFacade : testList) {
            uris.add(((Campaign)campaignFacade).getSourceURI());
        }
        pman.setChosenCampaignSourcefiles(uris);
        return oldList;
    }

    @Override
    public String getHTMLInfo(CampaignFacade campaign) {
        if (campaign == null || !(campaign instanceof Campaign)) {
            return "";
        }
        Campaign aCamp = (Campaign)campaign;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder(aCamp.getDisplayName());
        this.appendCampaignInfo(aCamp, infoText);
        return infoText.toString();
    }

    private void appendCampaignInfo(Campaign aCamp, HtmlInfoBuilder infoText) {
        List<String> copyright;
        String preString;
        List<CampaignURL> surveyURLs;
        List<CampaignURL> webURLs;
        String bString;
        CampaignSourceEntry image;
        infoText.appendLineBreak();
        if (aCamp.getSizeOfListFor(ListKey.FILE_COVER) > 0) {
            image = aCamp.getSafeListFor(ListKey.FILE_COVER).get(0);
            infoText.appendIconElement(image.getURI().toString());
        }
        if (aCamp.getSizeOfListFor(ListKey.FILE_LOGO) > 0) {
            image = aCamp.getSafeListFor(ListKey.FILE_LOGO).get(0);
            infoText.appendIconElement(image.getURI().toString());
        }
        if (aCamp.getSizeOfListFor(ListKey.FILE_COVER) > 0 || aCamp.getSizeOfListFor(ListKey.FILE_LOGO) > 0) {
            infoText.appendLineBreak();
        }
        if (StringUtils.isEmpty(bString = SourceFormat.getFormattedString(aCamp, SourceFormat.MEDIUM, true))) {
            bString = SourceFormat.getFormattedString(aCamp, SourceFormat.LONG, true);
        }
        infoText.appendI18nElement("in_sumSource", bString);
        infoText.appendI18nFormattedElement("in_infByPub", aCamp.getSafe(StringKey.PUB_NAME_LONG));
        infoText.appendLineBreak();
        Status status = aCamp.getSafe(ObjectKey.STATUS);
        infoText.appendI18nElement("in_infStatus", "<font color=\"#" + Integer.toHexString(status.getColor()) + "\">" + (Object)((Object)status) + "</font>");
        infoText.appendLineBreak();
        String descr = aCamp.get(StringKey.DESCRIPTION);
        if (descr != null) {
            infoText.appendI18nElement("in_infDesc", descr);
            infoText.appendLineBreak();
        }
        if (!(webURLs = Gui2CampaignInfoFactory.getUrlListForKind(aCamp, CampaignURL.URLKind.WEBSITE)).isEmpty()) {
            infoText.appendI18nElement("in_infWebsite", Gui2CampaignInfoFactory.buildURLListString(webURLs));
            infoText.appendLineBreak();
        }
        if (aCamp.getType().length() > 0) {
            infoText.appendI18nElement("in_infType", aCamp.getType());
            infoText.appendSpacer();
        }
        infoText.appendI18nElement("in_infRank", String.valueOf(aCamp.getSafe(IntegerKey.CAMPAIGN_RANK)));
        if (StringUtil.join(aCamp.getSafeListFor(ListKey.GAME_MODE), (String)", ").length() > 0) {
            infoText.appendSpacer();
            infoText.appendI18nElement("in_infGame", StringUtil.join(aCamp.getSafeListFor(ListKey.GAME_MODE), (String)", "));
        }
        infoText.appendLineBreak();
        List<CampaignURL> purchaseURLs = Gui2CampaignInfoFactory.getUrlListForKind(aCamp, CampaignURL.URLKind.PURCHASE);
        if (!purchaseURLs.isEmpty()) {
            infoText.appendI18nElement("in_infPurchase", Gui2CampaignInfoFactory.buildURLListString(purchaseURLs));
            infoText.appendLineBreak();
        }
        if (!(surveyURLs = Gui2CampaignInfoFactory.getUrlListForKind(aCamp, CampaignURL.URLKind.SURVEY)).isEmpty()) {
            infoText.appendI18nElement("in_infSurvey", Gui2CampaignInfoFactory.buildURLListString(surveyURLs));
            infoText.appendLineBreak();
        }
        if ((preString = PrerequisiteUtilities.preReqHTMLStringsForList(null, null, aCamp.getPrerequisiteList(), false)).length() > 0) {
            infoText.appendI18nFormattedElement("in_InfoRequirements", preString);
        }
        boolean infoDisplayed = false;
        List<String> info = aCamp.getListFor(ListKey.INFO_TEXT);
        if (info != null) {
            if (!infoDisplayed) {
                infoText.appendLineBreak();
            }
            infoText.appendSmallTitleElement(LanguageBundle.getString("in_infInf"));
            infoText.appendLineBreak();
            for (String infotext : info) {
                infoText.append(infotext);
                infoText.appendLineBreak();
            }
            infoDisplayed = true;
        }
        if ((copyright = aCamp.getListFor(ListKey.SECTION_15)) != null) {
            if (!infoDisplayed) {
                infoText.appendLineBreak();
            }
            infoText.appendSmallTitleElement(LanguageBundle.getString("in_infCopyright"));
            infoText.appendLineBreak();
            for (String license : copyright) {
                infoText.append(license);
                infoText.appendLineBreak();
            }
        }
        List<Campaign> subCampaigns = aCamp.getSubCampaigns();
        List<CampaignSourceEntry> notFoundSubCampaigns = aCamp.getNotFoundSubCampaigns();
        if (!(subCampaigns == null || notFoundSubCampaigns == null || subCampaigns.isEmpty() && notFoundSubCampaigns.isEmpty())) {
            infoText.appendLineBreak();
            infoText.appendSmallTitleElement(LanguageBundle.getString("in_infIncludedCampaigns"));
            infoText.appendLineBreak();
            for (Campaign subCamp : subCampaigns) {
                infoText.append(subCamp.getDisplayName());
                infoText.appendLineBreak();
            }
            for (CampaignSourceEntry subCse : notFoundSubCampaigns) {
                infoText.append(LanguageBundle.getFormattedString("in_infMissingCampaign", subCse.getURI()));
                infoText.appendLineBreak();
            }
        }
        infoText.appendLineBreak();
        infoText.appendI18nElement("in_infPccPath", aCamp.getSourceURI().getPath());
    }

    @Override
    public String getHTMLInfo(SourceSelectionFacade selection) {
        if (selection.getCampaigns().getSize() == 1) {
            return this.getHTMLInfo(selection.getCampaigns().getElementAt(0));
        }
        HtmlInfoBuilder infoText = new HtmlInfoBuilder(selection.toString());
        for (CampaignFacade campaign : selection.getCampaigns()) {
            if (campaign == null || !(campaign instanceof Campaign)) continue;
            Campaign aCamp = (Campaign)campaign;
            infoText.appendLineBreak();
            infoText.appendLineBreak();
            infoText.appendTitleElement(aCamp.getDisplayName());
            this.appendCampaignInfo(aCamp, infoText);
        }
        return infoText.toString();
    }

    private static String buildURLListString(List<CampaignURL> urlList) {
        StringBuilder sb = new StringBuilder(250);
        boolean first = true;
        for (CampaignURL campaignURL : urlList) {
            if (first) {
                first = false;
            } else {
                sb.append(" | ");
            }
            sb.append("<a href=\"").append(campaignURL.getUri().toString());
            sb.append("\">").append(campaignURL.getUrlDesc());
            sb.append("</a>");
        }
        return sb.toString();
    }

    public static List<CampaignURL> getUrlListForKind(Campaign c, CampaignURL.URLKind kind) {
        ArrayList<CampaignURL> kindList = new ArrayList<CampaignURL>();
        for (CampaignURL url : c.getSafeListFor(ListKey.CAMPAIGN_URL)) {
            if (url.getUrlKind() != kind) continue;
            kindList.add(url);
        }
        return kindList;
    }

    @Override
    public String getRequirementsHTMLString(CampaignFacade campaign, List<CampaignFacade> testList) {
        if (campaign == null || !(campaign instanceof Campaign)) {
            return "";
        }
        Campaign aCamp = (Campaign)campaign;
        PersistenceManager pman = PersistenceManager.getInstance();
        List<URI> oldList = this.setSourcesForPrereqTesting(testList, pman);
        String preReqHtml = PrerequisiteUtilities.preReqHTMLStringsForList(null, null, aCamp.getPrerequisiteList(), false);
        pman.setChosenCampaignSourcefiles(oldList);
        return preReqHtml;
    }
}

