/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.facade.core.AlignmentFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.GenderFacade;
import pcgen.facade.core.HandedFacade;
import pcgen.facade.core.SimpleFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tabs.models.FormattedFieldHandler;
import pcgen.gui2.tabs.models.TextFieldHandler;
import pcgen.gui2.util.ScrollablePanel;
import pcgen.system.LanguageBundle;

public class BiographyInfoPane
extends JPanel
implements CharacterInfoTab {
    private static final String ALL_COMMAND = "ALL";
    private static final String NONE_COMMAND = "NONE";
    private static final JTextField templateTextField = new JTextField("PrototypeDisplayText");
    private static final EnumSet<BiographyField> defaultBioFieds = EnumSet.range(BiographyField.NAME, BiographyField.WEIGHT);
    private final TabTitle title = new TabTitle(LanguageBundle.getString("in_descBiography"), null);
    private final JButton allButton = new JButton();
    private final JButton noneButton = new JButton();
    private final JPanel itemsPanel = new ScrollablePanel(20);
    private JButton addCustomItemButton;
    private JScrollPane detailsScroll;

    public BiographyInfoPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Box vbox = Box.createVerticalBox();
        this.allButton.setText(LanguageBundle.getString("in_all"));
        this.allButton.setActionCommand(ALL_COMMAND);
        this.noneButton.setText(LanguageBundle.getString("in_none"));
        this.noneButton.setActionCommand(NONE_COMMAND);
        Box hbox = Box.createHorizontalBox();
        hbox.add(new JLabel(LanguageBundle.getString("in_descCheckItem")));
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(this.allButton);
        hbox.add(Box.createRigidArea(new Dimension(3, 0)));
        hbox.add(this.noneButton);
        vbox.add(hbox);
        this.itemsPanel.setLayout(new GridBagLayout());
        this.itemsPanel.setBorder(new EmptyBorder(8, 5, 8, 5));
        vbox.add(Box.createVerticalStrut(10));
        this.detailsScroll = new JScrollPane(this.itemsPanel);
        this.detailsScroll.setPreferredSize(this.detailsScroll.getMaximumSize());
        this.detailsScroll.setHorizontalScrollBarPolicy(30);
        this.detailsScroll.setVerticalScrollBarPolicy(20);
        this.detailsScroll.setMinimumSize(new Dimension(600, 0));
        vbox.add(this.detailsScroll);
        vbox.add(Box.createVerticalStrut(10));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        this.addCustomItemButton = new JButton();
        hbox.add(this.addCustomItemButton);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalGlue());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)vbox, gbc);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(ItemHandler.class, new ItemHandler(character));
        models.put(AddCustomAction.class, new AddCustomAction(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(ItemHandler.class).install(this);
        this.addCustomItemButton.setAction(models.get(AddCustomAction.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(ItemHandler.class).uninstall(this);
    }

    @Override
    public TabTitle getTabTitle() {
        return this.title;
    }

    private class AddCustomAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AddCustomAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_descAddDetail"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<BiographyField> availFields = new ArrayList<BiographyField>(Arrays.asList(BiographyField.values()));
            availFields.removeAll(defaultBioFieds);
            for (BiographyField field : this.character.getDescriptionFacade().getCustomBiographyFields()) {
                availFields.remove((Object)field);
            }
            if (availFields.isEmpty()) {
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BiographyInfoPane.this.addCustomItemButton), LanguageBundle.getString("in_descNoMoreDetails"), "PCGen", 1);
                return;
            }
            Object[] fieldNames = new String[availFields.size()];
            int i = 0;
            for (BiographyField biographyField : availFields) {
                fieldNames[i++] = LanguageBundle.getString(biographyField.getIl8nKey());
            }
            String s = (String)JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(BiographyInfoPane.this.addCustomItemButton), LanguageBundle.getString("in_descAddFieldMsg"), LanguageBundle.getString("in_descAddFieldTitle"), 3, null, fieldNames, fieldNames[0]);
            if (StringUtils.isEmpty(s)) {
                return;
            }
            for (BiographyField field : availFields) {
                if (!s.equals(LanguageBundle.getString(field.getIl8nKey()))) continue;
                this.character.getDescriptionFacade().addCustomBiographyField(field);
                break;
            }
        }
    }

    private static abstract class BioItem
    implements ActionListener,
    ItemListener {
        private final JLabel label = new JLabel();
        private final JCheckBox checkbox = new JCheckBox();
        private JComboBox combobox = null;
        private JTextField textField = null;
        private JLabel trailinglabel = null;
        private final BiographyField bioField;
        private final CharacterFacade character;
        private TextFieldHandler textFieldHandler;
        private FormattedFieldHandler formattedFieldHandler;

        protected BioItem(String text, BiographyField bioField, CharacterFacade character) {
            this.bioField = bioField;
            this.character = character;
            if (text.startsWith("in_")) {
                this.label.setText(LanguageBundle.getString(text) + ":");
            } else {
                this.label.setText(text);
            }
            this.label.setHorizontalAlignment(4);
            if (character != null) {
                this.checkbox.setSelected(character.getExportBioField(bioField));
            }
        }

        public void addComponents(JPanel panel) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 19;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            panel.add((Component)this.checkbox, gbc);
            gbc.insets = new Insets(1, 2, 1, 2);
            panel.add((Component)this.label, gbc);
            int numComponents = 0;
            numComponents += this.textField != null ? 1 : 0;
            numComponents += this.combobox != null ? 1 : 0;
            switch (numComponents += this.trailinglabel != null ? 1 : 0) {
                case 3: {
                    gbc.weightx = 0.3333;
                    break;
                }
                case 2: {
                    gbc.weightx = 0.5;
                    break;
                }
                default: {
                    gbc.weightx = 1.0;
                }
            }
            if (this.combobox != null) {
                panel.add((Component)this.combobox, gbc);
            }
            if (this.trailinglabel == null) {
                gbc.gridwidth = 0;
            }
            if (this.textField != null) {
                panel.add((Component)this.textField, gbc);
            }
            gbc.gridwidth = 0;
            if (this.trailinglabel != null) {
                panel.add((Component)this.trailinglabel, gbc);
            } else if (numComponents < 2) {
                panel.add(Box.createHorizontalGlue(), gbc);
            }
        }

        protected void setTextFieldHandler(TextFieldHandler handler) {
            if (this.textField != null) {
                throw new IllegalStateException("The TextField has already been set");
            }
            this.textField = handler.getTextField();
            this.textFieldHandler = handler;
        }

        protected void setFormattedFieldHandler(FormattedFieldHandler handler) {
            if (this.textField != null) {
                throw new IllegalStateException("The TextField has already been set");
            }
            this.textField = handler.getFormattedTextField();
            this.formattedFieldHandler = handler;
        }

        protected void setComboBoxModel(CharacterComboBoxModel<?> model) {
            if (this.combobox != null) {
                throw new IllegalStateException("The CharacterComboBoxModel has already been set");
            }
            this.combobox = new JComboBox(model);
            this.combobox.setPreferredSize(new Dimension(10, templateTextField.getPreferredSize().height));
        }

        protected void setTrailingLabel(String text) {
            if (this.trailinglabel != null) {
                throw new IllegalStateException("The trailing label has already been set");
            }
            this.trailinglabel = new JLabel(text);
        }

        public void setVisible(boolean visible) {
            this.label.setVisible(visible);
            this.checkbox.setVisible(visible);
            if (this.combobox != null) {
                this.combobox.setVisible(visible);
            }
            if (this.textField != null) {
                this.textField.setVisible(visible);
            }
            if (this.trailinglabel != null) {
                this.trailinglabel.setVisible(visible);
            }
        }

        public void install(BiographyInfoPane parent) {
            parent.allButton.addActionListener(this);
            parent.noneButton.addActionListener(this);
            this.checkbox.addItemListener(this);
            if (this.textFieldHandler != null) {
                this.textFieldHandler.install();
            }
            if (this.formattedFieldHandler != null) {
                this.formattedFieldHandler.install();
            }
        }

        public void uninstall(BiographyInfoPane parent) {
            parent.allButton.removeActionListener(this);
            parent.noneButton.removeActionListener(this);
            this.checkbox.removeItemListener(this);
            if (this.textFieldHandler != null) {
                this.textFieldHandler.uninstall();
            }
            if (this.formattedFieldHandler != null) {
                this.formattedFieldHandler.uninstall();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BiographyInfoPane.ALL_COMMAND.equals(e.getActionCommand())) {
                this.checkbox.setSelected(true);
                this.character.setExportBioField(this.bioField, true);
            } else if (BiographyInfoPane.NONE_COMMAND.equals(e.getActionCommand())) {
                this.checkbox.setSelected(false);
                this.character.setExportBioField(this.bioField, false);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            this.character.setExportBioField(this.bioField, selected);
        }
    }

    private static class BiographyFieldBioItem
    extends BioItem {
        public BiographyFieldBioItem(String titleKey, final BiographyField field, final CharacterFacade character) {
            super(titleKey, field, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getDescriptionFacade().getBiographyField(field)){

                @Override
                protected void textChanged(String text) {
                    character.getDescriptionFacade().setBiographyField(field, text);
                }
            });
        }

        public BiographyFieldBioItem(final BiographyField field, final CharacterFacade character) {
            super(field.getIl8nKey(), field, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getDescriptionFacade().getBiographyField(field)){

                @Override
                protected void textChanged(String text) {
                    character.getDescriptionFacade().setBiographyField(field, text);
                }
            });
        }
    }

    private static class HairStyleItem
    extends BiographyFieldBioItem {
        public HairStyleItem(CharacterFacade character) {
            super("in_style", BiographyField.HAIR_STYLE, character);
        }
    }

    private static class RegionItem
    extends BioItem {
        public RegionItem(CharacterFacade character) {
            super("in_region", BiographyField.REGION, character);
            JTextField regionField = new JTextField();
            regionField.setEditable(false);
            this.setTextFieldHandler(new TextFieldHandler(regionField, character.getDescriptionFacade().getBiographyField(BiographyField.REGION)){

                @Override
                protected void textChanged(String text) {
                }
            });
        }
    }

    private static class WeightItem
    extends BioItem {
        public WeightItem(final CharacterFacade character) {
            super("in_weight", BiographyField.WEIGHT, character);
            this.setTrailingLabel(character.getDataSet().getGameMode().getWeightUnit());
            this.setFormattedFieldHandler(new FormattedFieldHandler(new JFormattedTextField(), character.getWeightRef()){

                @Override
                protected void valueChanged(int value) {
                    character.setWeight(value);
                }
            });
        }
    }

    private static class HeightItem
    extends BioItem {
        public HeightItem(final CharacterFacade character) {
            super("in_height", BiographyField.HEIGHT, character);
            this.setTrailingLabel(character.getDataSet().getGameMode().getHeightUnit());
            this.setFormattedFieldHandler(new FormattedFieldHandler(new JFormattedTextField(), character.getHeightRef()){

                @Override
                protected void valueChanged(int value) {
                    character.setHeight(value);
                }
            });
        }
    }

    private static class EyeColorItem
    extends BioItem {
        public EyeColorItem(final CharacterFacade character) {
            super("in_appEyeColor", BiographyField.EYE_COLOR, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getEyeColorRef()){

                @Override
                protected void textChanged(String text) {
                    character.setEyeColor(text);
                }
            });
        }
    }

    private static class HairColorItem
    extends BioItem {
        public HairColorItem(final CharacterFacade character) {
            super("in_appHairColor", BiographyField.HAIR_COLOR, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getHairColorRef()){

                @Override
                protected void textChanged(String text) {
                    character.setHairColor(text);
                }
            });
        }
    }

    private static class SkinColorItem
    extends BioItem {
        public SkinColorItem(final CharacterFacade character) {
            super("in_appSkintoneColor", BiographyField.SKIN_TONE, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getSkinColorRef()){

                @Override
                protected void textChanged(String text) {
                    character.setSkinColor(text);
                }
            });
        }
    }

    private static class AgeItem
    extends BioItem {
        public AgeItem(final CharacterFacade character) {
            super("in_age", BiographyField.AGE, character);
            CharacterComboBoxModel<SimpleFacade> ageModel = new CharacterComboBoxModel<SimpleFacade>(){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setAgeCategory((SimpleFacade)anItem);
                }
            };
            ageModel.setListFacade(character.getAgeCategories());
            ageModel.setReference(character.getAgeCategoryRef());
            this.setComboBoxModel(ageModel);
            this.setFormattedFieldHandler(new FormattedFieldHandler(new JFormattedTextField(), character.getAgeRef()){

                @Override
                protected void valueChanged(int value) {
                    character.setAge(value);
                }
            });
        }
    }

    private static class DeityItem
    extends BioItem {
        public DeityItem(final CharacterFacade character) {
            super("in_deity", BiographyField.DEITY, character);
            CharacterComboBoxModel<DeityFacade> deityModel = new CharacterComboBoxModel<DeityFacade>(){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setDeity((DeityFacade)anItem);
                }
            };
            deityModel.setListFacade(character.getDataSet().getDeities());
            deityModel.setReference(character.getDeityRef());
            this.setComboBoxModel(deityModel);
        }
    }

    private static class AlignmentItem
    extends BioItem {
        public AlignmentItem(final CharacterFacade character) {
            super("in_alignString", BiographyField.ALIGNMENT, character);
            CharacterComboBoxModel<AlignmentFacade> alignmentModel = new CharacterComboBoxModel<AlignmentFacade>(){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setAlignment((AlignmentFacade)anItem);
                }
            };
            alignmentModel.setListFacade(character.getDataSet().getAlignments());
            alignmentModel.setReference(character.getAlignmentRef());
            this.setComboBoxModel(alignmentModel);
        }
    }

    private static class HandedItem
    extends BioItem {
        private CharacterComboBoxModel<HandedFacade> handsModel;

        public HandedItem(final CharacterFacade character) {
            super("in_handString", BiographyField.HANDED, character);
            this.handsModel = new CharacterComboBoxModel<HandedFacade>(){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setHanded((HandedFacade)anItem);
                }
            };
            this.handsModel.setReference(character.getHandedRef());
            this.handsModel.setListFacade(character.getAvailableHands());
            this.setComboBoxModel(this.handsModel);
            this.checkVisible();
        }

        private void checkVisible() {
            this.setVisible(this.handsModel.getSize() != 0);
        }
    }

    private static class GenderItem
    extends BioItem {
        private CharacterComboBoxModel<GenderFacade> genderModel;

        public GenderItem(final CharacterFacade character) {
            super("in_gender", BiographyField.GENDER, character);
            this.genderModel = new CharacterComboBoxModel<GenderFacade>(){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setGender((GenderFacade)anItem);
                }
            };
            this.genderModel.setReference(character.getGenderRef());
            this.genderModel.setListFacade(character.getAvailableGenders());
            this.setComboBoxModel(this.genderModel);
            this.checkVisible();
        }

        private void checkVisible() {
            this.setVisible(this.genderModel.getSize() != 0);
        }
    }

    private static class PlayerNameItem
    extends BioItem {
        public PlayerNameItem(final CharacterFacade character) {
            super("in_player", BiographyField.PLAYERNAME, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(), character.getPlayersNameRef()){

                @Override
                protected void textChanged(String text) {
                    character.setPlayersName(text);
                }
            });
        }
    }

    private static class NameItem
    extends BioItem {
        public NameItem(final CharacterFacade character) {
            super("in_nameLabel", BiographyField.NAME, character);
            this.setTextFieldHandler(new TextFieldHandler(new JTextField(30), character.getNameRef()){

                @Override
                protected void textChanged(String text) {
                    character.setName(text);
                }
            });
        }
    }

    private class ItemHandler
    implements ListListener<BiographyField> {
        private final ListFacade<BiographyField> customFields;
        private List<BioItem> bioItems = new ArrayList<BioItem>();
        private Map<BiographyField, BioItem> customFieldMap = new EnumMap<BiographyField, BioItem>(BiographyField.class);
        private final CharacterFacade character;
        private BiographyInfoPane detailsPane;

        public ItemHandler(CharacterFacade character2) {
            this.character = character2;
            this.bioItems.add(new NameItem(this.character));
            this.bioItems.add(new PlayerNameItem(this.character));
            this.bioItems.add(new GenderItem(this.character));
            this.bioItems.add(new HandedItem(this.character));
            this.bioItems.add(new AlignmentItem(this.character));
            this.bioItems.add(new DeityItem(this.character));
            this.bioItems.add(new AgeItem(this.character));
            this.bioItems.add(new SkinColorItem(this.character));
            this.bioItems.add(new HairColorItem(this.character));
            this.bioItems.add(new HairStyleItem(this.character));
            this.bioItems.add(new EyeColorItem(this.character));
            this.bioItems.add(new HeightItem(this.character));
            this.bioItems.add(new WeightItem(this.character));
            this.customFields = this.character.getDescriptionFacade().getCustomBiographyFields();
            for (BiographyField field : this.customFields) {
                BioItem item = field == BiographyField.REGION ? new RegionItem(this.character) : new BiographyFieldBioItem(field, this.character);
                this.customFieldMap.put(field, item);
            }
        }

        public void install(BiographyInfoPane parent) {
            this.detailsPane = parent;
            BiographyInfoPane.this.itemsPanel.removeAll();
            for (BioItem bioItem : this.bioItems) {
                bioItem.addComponents(BiographyInfoPane.this.itemsPanel);
                bioItem.install(parent);
            }
            for (BioItem bioItem : this.customFieldMap.values()) {
                bioItem.addComponents(BiographyInfoPane.this.itemsPanel);
                bioItem.install(parent);
            }
            this.customFields.addListListener(this);
            BiographyInfoPane.this.detailsScroll.setPreferredSize(BiographyInfoPane.this.itemsPanel.getPreferredSize());
            BiographyInfoPane.this.detailsScroll.invalidate();
        }

        public void uninstall(BiographyInfoPane parent) {
            for (BioItem bioItem : this.bioItems) {
                bioItem.uninstall(parent);
            }
            for (BioItem bioItem : this.customFieldMap.values()) {
                bioItem.uninstall(parent);
            }
            this.detailsPane = null;
            this.customFields.removeListListener(this);
        }

        @Override
        public void elementAdded(ListEvent<BiographyField> e) {
            BiographyField field = e.getElement();
            BiographyFieldBioItem bioItem = new BiographyFieldBioItem(field, this.character);
            this.customFieldMap.put(field, bioItem);
            bioItem.addComponents(BiographyInfoPane.this.itemsPanel);
            bioItem.install(this.detailsPane);
            this.detailsPane.validate();
            BiographyInfoPane.this.detailsScroll.setPreferredSize(BiographyInfoPane.this.itemsPanel.getPreferredSize());
            BiographyInfoPane.this.detailsScroll.repaint();
        }

        @Override
        public void elementRemoved(ListEvent<BiographyField> e) {
            BiographyField field = e.getElement();
            BiographyFieldBioItem bioItem = new BiographyFieldBioItem(field, this.character);
            this.customFieldMap.put(field, bioItem);
            bioItem.uninstall(this.detailsPane);
            this.detailsPane.invalidate();
        }

        @Override
        public void elementsChanged(ListEvent<BiographyField> e) {
            BiographyInfoPane parent = this.detailsPane;
            this.uninstall(parent);
            this.install(parent);
            this.detailsPane.invalidate();
        }

        @Override
        public void elementModified(ListEvent<BiographyField> e) {
        }
    }
}

