/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.models;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;
import pcgen.gui2.util.treeview.DataView;
import pcgen.util.Logging;

public abstract class ConcurrentDataView<E>
implements DataView<E> {
    private static ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setName("concurrent-dataview-thread");
            return thread;
        }
    });
    private final Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            ConcurrentDataView.this.refreshTableData();
        }
    };
    private final Map<E, List<?>> dataMap = Collections.synchronizedMap(new WeakHashMap());
    private boolean installed = false;

    @Override
    public final List<?> getData(final E obj) {
        Future future = executor.submit(new Callable<List<?>>(){

            @Override
            public List<?> call() throws Exception {
                List<?> list = ConcurrentDataView.this.getDataList(obj);
                if (!list.equals(ConcurrentDataView.this.dataMap.get(obj)) && ConcurrentDataView.this.dataMap.put(obj, list) != null && ConcurrentDataView.this.installed) {
                    SwingUtilities.invokeLater(ConcurrentDataView.this.refreshRunnable);
                }
                return list;
            }
        });
        if (!this.dataMap.containsKey(obj)) {
            try {
                return (List)future.get();
            }
            catch (InterruptedException ex) {
                Logging.errorPrint(null, ex);
            }
            catch (ExecutionException ex) {
                Logging.errorPrint(null, ex);
            }
            return Collections.emptyList();
        }
        return this.dataMap.get(obj);
    }

    public void install() {
        this.installed = true;
    }

    public void uninstall() {
        this.installed = false;
    }

    protected abstract List<?> getDataList(E var1);

    protected abstract void refreshTableData();
}

