/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;
import pcgen.gui2.tools.DesktopBrowserLauncher;
import pcgen.system.PCGenSettings;

public final class Utility {
    private static final KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
    public static final String dispatchWindowClosingActionMapKey = "pcgen:WINDOW_CLOSING";

    public static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy, int fill, int anchor) {
        Utility.buildConstraints(gbc, gx, gy, gw, gh, wx, wy);
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    public static void buildRelativeConstraints(GridBagConstraints gbc, int gw, int gh, double wx, double wy, int fill, int anchor) {
        Utility.buildConstraints(gbc, -1, -1, gw, gh, wx, wy);
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    public static void buildRelativeConstraints(GridBagConstraints gbc, int gw, int gh, double wx, double wy) {
        Utility.buildConstraints(gbc, -1, -1, gw, gh, wx, wy);
    }

    public static void centerDialog(JDialog dialog) {
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Dimension dialogSize = dialog.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        dialog.setSize(dialogSize);
        dialog.setLocation(screenSize.x + (screenSize.width - dialogSize.width) / 2, screenSize.y + (screenSize.height - dialogSize.height) / 2);
    }

    public static void resizeDialogToScreen(JDialog dialog) {
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension dialogSize = dialog.getSize();
        if (dialogSize.height > screenBounds.height) {
            dialogSize.height = screenBounds.height;
        }
        if (dialogSize.width > screenBounds.width) {
            dialogSize.width = screenBounds.width;
        }
        dialog.setSize(dialogSize);
    }

    public static void setDialogRelativeLocation(Component parent, JDialog dialog) {
        Utility.resizeDialogToScreen(dialog);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Point centreOfParent = new Point(parent.getWidth() / 2, parent.getHeight() / 2);
        SwingUtilities.convertPointToScreen(centreOfParent, parent);
        Point location = new Point(centreOfParent.x - dialog.getWidth() / 2, centreOfParent.y - dialog.getHeight() / 2);
        if (location.x + dialog.getWidth() > screenBounds.width + screenBounds.x) {
            location.x -= location.x + dialog.getWidth() - (screenBounds.width + screenBounds.x);
        }
        if (location.x < screenBounds.x) {
            location.x = screenBounds.x;
        }
        if (location.y + dialog.getHeight() > screenBounds.height + screenBounds.y) {
            location.y -= location.y + dialog.getHeight() - (screenBounds.height + screenBounds.y);
        }
        if (location.y < screenBounds.y) {
            location.y = screenBounds.y;
        }
        dialog.setLocation(location);
    }

    public static void centerFrame(JFrame frame, boolean isPopup) {
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        if (isPopup) {
            frame.setSize(screenSize.width / 2, screenSize.height / 2);
        }
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation(screenSize.x + (screenSize.width - frameSize.width) / 2, screenSize.y + (screenSize.height - frameSize.height) / 2);
    }

    public static void selectDefaultBrowser(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Find and select your preferred html browser.");
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            fc.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
        }
        if (PCGenSettings.getBrowserPath() != null) {
            fc.setCurrentDirectory(new File(PCGenSettings.getBrowserPath()));
        }
        int returnVal = fc.showOpenDialog(parent);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            PCGenSettings.OPTIONS_CONTEXT.setProperty("browserPath", file.getAbsolutePath());
        }
    }

    public static void viewInBrowser(String url) throws IOException {
        Utility.viewInBrowser(new URL(url));
    }

    public static void viewInBrowser(File f) throws IOException {
        Utility.viewInBrowser(f.toURI());
    }

    public static void viewInBrowser(URL url) throws IOException {
        try {
            Utility.viewInBrowser(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public static void viewInBrowser(URI uri) throws IOException {
        if (!DesktopBrowserLauncher.isBrowseSupported() && SystemUtils.IS_OS_WINDOWS && PCGenSettings.getBrowserPath() == null) {
            Utility.selectDefaultBrowser(null);
        }
        DesktopBrowserLauncher.browse(uri);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }

    public static void adjustRectToFitImage(BufferedImage image, Rectangle cropRect) {
        if (cropRect.width > image.getWidth()) {
            cropRect.width = image.getWidth();
        }
        if (cropRect.height > image.getHeight()) {
            cropRect.height = image.getHeight();
        }
        int dimension = Math.min(cropRect.width, cropRect.height);
        cropRect.setSize(dimension, dimension);
        if (cropRect.x + cropRect.width > image.getWidth()) {
            cropRect.x = image.getWidth() - cropRect.width;
        }
        if (cropRect.y + cropRect.height > image.getHeight()) {
            cropRect.y = image.getHeight() - cropRect.height;
        }
    }

    public static final void setApplicationTitle(String title) {
        Toolkit xToolkit = Toolkit.getDefaultToolkit();
        try {
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, title);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static String shortenString(FontMetrics fm, String string, int maxWidth) {
        for (int i = string.length(); i > 0; i -= 5) {
            String foo = "..." + string.substring(string.length() - i);
            int width = fm.stringWidth(foo);
            if (width >= maxWidth) continue;
            return foo;
        }
        return "";
    }

    public static JTabbedPane getTabbedPaneFor(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JTabbedPane) {
            return (JTabbedPane)c;
        }
        return Utility.getTabbedPaneFor(c.getParent());
    }
}

