/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.File;
import java.net.URI;

public final class PCGFile {
    private PCGFile() {
    }

    public static boolean isPCGenCharacterFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcg");
    }

    public static boolean isPCGenPartyFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcp");
    }

    public static boolean isPCGenCampaignFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcc");
    }

    public static boolean isPCGenCampaignFile(URI uri) {
        if ("file".equals(uri.getScheme())) {
            return PCGFile.isPCGenCampaignFile(new File(uri));
        }
        return uri.getPath() != null && uri.getPath().toLowerCase().endsWith(".pcc");
    }

    public static boolean isPCGenListFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".lst");
    }

    public static boolean isPCGenCharacterOrPartyFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String name = PCGFile.getWindowsSafeFilename(file);
        return name.endsWith(".pcg") || name.endsWith(".pcp");
    }

    private static String getWindowsSafeFilename(File file) {
        return file.getName().toLowerCase();
    }
}

