/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.GenericMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.helper.Aspect;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.BenefitFormatting;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.QualifiedName;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class AbilityToken
extends Token {
    public static final String TOKENNAME = "ABILITY";
    private MapToList<Ability, CNAbility> abilityList = new HashMapToList();
    private View view = View.VISIBLE_EXPORT;
    private PlayerCharacter cachedPC = null;
    private int cachedPcSerial = 0;
    private String lastToken = null;
    private AbilityCategory lastCategory = null;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String tokenString = aTok.nextToken();
        String categoryString = aTok.nextToken();
        AbilityCategory aCategory = "ANY".equals(categoryString) ? AbilityCategory.ANY : SettingsHandler.getGame().getAbilityCategory(categoryString);
        return this.getTokenForCategory(tokenSource, pc, eh, aTok, tokenString, aCategory);
    }

    protected String getTokenForCategory(String tokenSource, PlayerCharacter pc, ExportHandler eh, StringTokenizer aTok, String tokenString, AbilityCategory aCategory) {
        boolean cacheAbilityProcessingData;
        boolean bl = cacheAbilityProcessingData = this.cachedPC != pc || !aCategory.equals(this.lastCategory) || this.cachedPcSerial != pc.getSerial() || !tokenString.equals(this.lastToken);
        if (cacheAbilityProcessingData) {
            this.abilityList = this.getAbilityList(pc, aCategory);
            this.cachedPC = pc;
            this.lastCategory = aCategory;
            this.cachedPcSerial = pc.getSerial();
            this.lastToken = tokenString;
        }
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> negate = new ArrayList<String>();
        String abilityType = null;
        String key = null;
        String aspect = null;
        int abilityIndex = -1;
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            try {
                abilityIndex = Integer.parseInt(bString);
                break;
            }
            catch (NumberFormatException exc) {
                if (bString.equals("VISIBLE")) {
                    this.view = View.VISIBLE_EXPORT;
                    continue;
                }
                if (bString.equals("HIDDEN")) {
                    this.view = View.HIDDEN_EXPORT;
                    continue;
                }
                if (bString.equals("ALL")) {
                    this.view = View.ALL;
                    continue;
                }
                abilityType = bString;
            }
        }
        while (aTok.hasMoreTokens()) {
            int aspectInd;
            int keyInd;
            String typeStr = aTok.nextToken();
            int typeInd = typeStr.indexOf("TYPE=");
            int extypeInd = typeStr.indexOf("EXCLUDETYPE=");
            if (typeInd != -1 && extypeInd == -1 && typeStr.length() > 5) {
                if (typeStr.startsWith("!")) {
                    Logging.deprecationPrint("The use of !TYPE with ABILITY output tokens is deprecated. Please use EXCLUDETYPE.");
                    negate.add(typeStr.substring(typeInd + 5));
                } else {
                    StringTokenizer incTok = new StringTokenizer(typeStr.substring(typeInd + 5), ";");
                    while (incTok.hasMoreTokens()) {
                        types.add(incTok.nextToken());
                    }
                }
            }
            if (extypeInd != -1 && typeStr.length() > 12) {
                StringTokenizer exTok = new StringTokenizer(typeStr.substring(extypeInd + 12), ";");
                while (exTok.hasMoreTokens()) {
                    negate.add(exTok.nextToken());
                }
            }
            if ((keyInd = typeStr.indexOf("KEY=")) != -1 && typeStr.length() > 4) {
                key = typeStr.substring(keyInd + 4);
            }
            if ((aspectInd = typeStr.indexOf("ASPECT=")) == -1 || typeStr.length() <= 7) continue;
            aspect = typeStr.substring(aspectInd + 7);
        }
        MapToList<Ability, CNAbility> aList = null;
        aList = key == null ? AbilityToken.buildAbilityList(types, negate, abilityType, this.view, aspect, this.abilityList) : AbilityToken.buildAbilityList(key, this.view, this.abilityList);
        String retString = this.getRetString(tokenSource, pc, eh, abilityIndex, aList);
        return retString;
    }

    static MapToList<Ability, CNAbility> buildAbilityList(List<String> types, List<String> negate, String abilityType, View view, String aspect, MapToList<Ability, CNAbility> listOfAbilities) {
        ArrayList aList = new ArrayList();
        aList.addAll(listOfAbilities.getKeySet());
        Globals.sortPObjectListByName(aList);
        boolean matchTypeDef = false;
        boolean matchVisibilityDef = false;
        boolean matchAspectDef = false;
        ArrayList<Ability> bList = new ArrayList<Ability>();
        for (Ability aAbility : aList) {
            matchTypeDef = AbilityToken.abilityMatchesType(abilityType, aAbility, types, negate);
            matchVisibilityDef = AbilityToken.abilityVisibleTo(view, aAbility);
            matchAspectDef = AbilityToken.abilityMatchesAspect(aspect, aAbility);
            if (!matchTypeDef || !matchVisibilityDef || !matchAspectDef) continue;
            bList.add(aAbility);
        }
        try {
            GenericMapToList mtl = new GenericMapToList(LinkedHashMap.class);
            for (Ability a : bList) {
                mtl.addAllToListFor((Object)a, (Collection)listOfAbilities.getListFor((Object)a));
            }
            return mtl;
        }
        catch (InstantiationException e) {
            throw new UnreachableError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableError((Throwable)e);
        }
    }

    static MapToList<Ability, CNAbility> buildAbilityList(String key, View view, MapToList<Ability, CNAbility> listOfAbilities) {
        ArrayList aList = new ArrayList();
        aList.addAll(listOfAbilities.getKeySet());
        Globals.sortPObjectListByName(aList);
        boolean matchKeyDef = false;
        boolean matchVisibilityDef = false;
        ArrayList<Ability> bList = new ArrayList<Ability>();
        for (Ability aAbility : aList) {
            matchKeyDef = aAbility.getKeyName().equalsIgnoreCase(key);
            matchVisibilityDef = AbilityToken.abilityVisibleTo(view, aAbility);
            if (!matchKeyDef || !matchVisibilityDef) continue;
            bList.add(aAbility);
        }
        try {
            GenericMapToList mtl = new GenericMapToList(LinkedHashMap.class);
            for (Ability a : bList) {
                mtl.addAllToListFor((Object)a, (Collection)listOfAbilities.getListFor((Object)a));
            }
            return mtl;
        }
        catch (InstantiationException e) {
            throw new UnreachableError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableError((Throwable)e);
        }
    }

    static boolean abilityMatchesType(String abilityType, Ability aAbility, List<String> types, List<String> negate) {
        boolean matchTypeDef = false;
        if (abilityType != null) {
            if (aAbility.isType(abilityType)) {
                matchTypeDef = true;
            }
        } else {
            matchTypeDef = true;
        }
        boolean istype = false;
        boolean isnttype = true;
        if (types.size() > 0) {
            for (String typeStr : types) {
                istype |= aAbility.isType(typeStr);
            }
        } else {
            istype = true;
        }
        for (String typeStr : negate) {
            isnttype &= !aAbility.isType(typeStr);
        }
        matchTypeDef = matchTypeDef && istype && isnttype;
        return matchTypeDef;
    }

    static boolean abilityVisibleTo(View v, Ability aAbility) {
        return aAbility.getSafe(ObjectKey.VISIBILITY).isVisibleTo(v);
    }

    static boolean abilityMatchesAspect(String aspect, Ability aAbility) {
        return aspect == null || aAbility.get(MapKey.ASPECT, AspectName.getConstant(aspect)) != null;
    }

    private String getRetString(String tokenSource, PlayerCharacter pc, ExportHandler eh, int abilityIndex, MapToList<Ability, CNAbility> aMapToList) {
        String retString = "";
        ArrayList aList = new ArrayList(aMapToList.getKeySet());
        if (abilityIndex >= 0 && abilityIndex < aList.size()) {
            Ability aAbility = (Ability)aList.get(abilityIndex);
            List abilities = aMapToList.getListFor((Object)aAbility);
            if (abilities.size() == 0) {
                return "";
            }
            if (abilityIndex == aList.size() - 1 && eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
            if (tokenSource.endsWith(".DESC")) {
                retString = pc.getDescription(abilities);
            } else if (tokenSource.endsWith(".BENEFIT")) {
                retString = BenefitFormatting.getBenefits(pc, abilities);
            } else if (tokenSource.endsWith(".TYPE")) {
                retString = aAbility.getType().toUpperCase();
            } else if (tokenSource.endsWith(".ASSOCIATED")) {
                ArrayList<String> assocs = new ArrayList<String>();
                for (CNAbility cna : abilities) {
                    assocs.addAll(pc.getAssociationExportList(cna));
                }
                Collections.sort(assocs);
                retString = StringUtil.join(assocs, (String)",");
            } else if (tokenSource.indexOf(".ASSOCIATED.") > -1) {
                String key = tokenSource.substring(tokenSource.indexOf(".ASSOCIATED.") + 12);
                retString = this.getAssociationString(pc, abilities, key);
            } else if (tokenSource.endsWith(".ASSOCIATEDCOUNT")) {
                int count = 0;
                for (CNAbility cna : abilities) {
                    count += pc.getDetailedAssociationCount(cna);
                }
                retString = Integer.toString(count);
            } else if (tokenSource.endsWith(".SOURCE")) {
                retString = SourceFormat.getFormattedString(aAbility, Globals.getSourceDisplay(), true);
            } else if (tokenSource.endsWith(".SOURCESHORT")) {
                retString = SourceFormat.formatShort(aAbility, 8);
            } else if (tokenSource.endsWith(".ASPECT")) {
                retString = this.getAspectString(pc, abilities);
            } else if (tokenSource.indexOf(".ASPECT.") > -1) {
                String key = tokenSource.substring(tokenSource.indexOf(".ASPECT.") + 8);
                retString = this.getAspectString(pc, abilities, key);
            } else if (tokenSource.endsWith(".ASPECTCOUNT")) {
                retString = Integer.toString(aAbility.getSafeSizeOfMapFor(MapKey.ASPECT));
            } else if (tokenSource.indexOf(".HASASPECT.") > -1) {
                String key = tokenSource.substring(tokenSource.indexOf(".HASASPECT.") + 11);
                retString = this.getHasAspectString(pc, aAbility, AspectName.getConstant(key));
            } else {
                retString = tokenSource.indexOf(".NAME") > -1 ? aAbility.getDisplayName() : (tokenSource.indexOf(".KEY") > -1 ? aAbility.getKeyName() : QualifiedName.qualifiedName(pc, abilities));
            }
        } else if (eh != null && eh.getExistsOnly()) {
            eh.setNoMoreItems(true);
        }
        return retString;
    }

    protected Nature getTargetNature() {
        return Nature.NORMAL;
    }

    private String getAssociationString(PlayerCharacter pc, List<CNAbility> abilities, String key) {
        int index = Integer.parseInt(key);
        if (index < 0) {
            return "";
        }
        ArrayList<String> assocs = new ArrayList<String>();
        for (CNAbility cna : abilities) {
            assocs.addAll(pc.getAssociationExportList(cna));
        }
        Collections.sort(assocs);
        int count = assocs.size();
        if (index < count) {
            return (String)assocs.get(index);
        }
        return "";
    }

    private String getAspectString(PlayerCharacter pc, List<CNAbility> abilities) {
        if (abilities.size() == 0) {
            return "";
        }
        Ability sampleAbilityObject = abilities.get(0).getAbility();
        Set<AspectName> aspectKeys = sampleAbilityObject.getKeysFor(MapKey.ASPECT);
        TreeSet<AspectName> sortedKeys = new TreeSet<AspectName>(aspectKeys);
        StringBuilder buff = new StringBuilder();
        for (AspectName key : sortedKeys) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(Aspect.printAspect(pc, key, abilities));
        }
        return buff.toString();
    }

    private String getAspectString(PlayerCharacter pc, List<CNAbility> abilities, String key) {
        if (key == null) {
            return "";
        }
        if (abilities.size() == 0) {
            return "";
        }
        Ability sampleAbilityObject = abilities.get(0).getAbility();
        try {
            int index = Integer.parseInt(key);
            if (index >= 0 && index < sampleAbilityObject.getSafeSizeOfMapFor(MapKey.ASPECT)) {
                Set<AspectName> aspectKeys = sampleAbilityObject.getKeysFor(MapKey.ASPECT);
                ArrayList<AspectName> sortedKeys = new ArrayList<AspectName>(aspectKeys);
                Collections.sort(sortedKeys);
                AspectName aspectName = (AspectName)sortedKeys.get(index);
                return Aspect.printAspect(pc, aspectName, abilities);
            }
            return "";
        }
        catch (NumberFormatException e) {
            AspectName aspectName = AspectName.getConstant(key);
            return Aspect.printAspectValue(pc, aspectName, abilities);
        }
    }

    private String getHasAspectString(PlayerCharacter pc, Ability ability, AspectName key) {
        List<Aspect> aspects = ability.get(MapKey.ASPECT, key);
        Aspect aspect = Aspect.lastPassingAspect(aspects, pc, ability);
        if (aspect == null) {
            return "N";
        }
        return "Y";
    }

    protected MapToList<Ability, CNAbility> getAbilityList(PlayerCharacter pc, AbilityCategory aCategory) {
        HashMapToList listOfAbilities = new HashMapToList();
        Collection<AbilityCategory> allCats = SettingsHandler.getGame().getAllAbilityCategories();
        for (AbilityCategory aCat : allCats) {
            if (!AbilityCategory.ANY.equals(aCategory) && !aCat.getParentCategory().equals(aCategory)) continue;
            for (CNAbility cna : pc.getPoolAbilities(aCat, Nature.NORMAL)) {
                listOfAbilities.addToListFor((Object)cna.getAbility(), (Object)cna);
            }
        }
        return listOfAbilities;
    }

    protected View getView() {
        return this.view;
    }

    protected void setView(View v) {
        this.view = v;
    }
}

