/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.utils.CoreUtility;
import pcgen.io.filters.OutputFilter;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class CharacterFilter
implements OutputFilter {
    private String outputFilterName = "";
    private Map<Integer, String> outputFilter = null;

    public CharacterFilter(String templateFileName) {
        int idx = templateFileName.lastIndexOf(46);
        String filterName = templateFileName;
        if (idx >= 0) {
            filterName = filterName.substring(idx + 1);
        }
        if ((filterName = filterName.toLowerCase()).equals(this.outputFilterName)) {
            return;
        }
        this.outputFilter = null;
        filterName = new File(ConfigurationSettings.getSystemsDir()) + File.separator + "outputFilters" + File.separator + filterName + ".lst";
        File filterFile = new File(filterName);
        try {
            if (filterFile.canRead() && filterFile.isFile()) {
                String aLine;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filterFile), "UTF-8"));
                this.outputFilterName = filterName;
                this.outputFilter = new HashMap<Integer, String>();
                while ((aLine = br.readLine()) != null) {
                    List<String> filterEntry = CoreUtility.split(aLine, '\t');
                    if (filterEntry.size() < 2) continue;
                    try {
                        Integer key = Delta.decode(filterEntry.get(0));
                        this.outputFilter.put(key, filterEntry.get(1));
                    }
                    catch (NullPointerException e) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                    }
                    catch (NumberFormatException e) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                    }
                }
                br.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public String filterString(String aString) {
        if (this.outputFilter != null && !this.outputFilter.isEmpty() && aString != null) {
            StringBuilder xlatedString = new StringBuilder(aString.length());
            for (int i = 0; i < aString.length(); ++i) {
                char c = aString.charAt(i);
                String xlation = this.outputFilter.get(c);
                if (xlation != null) {
                    xlatedString.append(xlation);
                    continue;
                }
                xlatedString.append(c);
            }
            aString = xlatedString.toString();
        }
        return aString;
    }
}

