/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignLoader;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.system.PCGenTask;
import pcgen.util.Logging;

public class CampaignFileLoader
extends PCGenTask {
    private File alternateSourceFolder = null;
    private final FilenameFilter pccFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File parentDir, String fileName) {
            if (".svn".equals(fileName)) {
                return false;
            }
            if (StringUtils.endsWithIgnoreCase(fileName, ".pcc")) {
                return true;
            }
            return new File(parentDir, fileName).isDirectory();
        }
    };
    private LinkedList<URI> campaignFiles = new LinkedList();

    @Override
    public String getMessage() {
        return LanguageBundle.getString("in_taskLoadCampaigns");
    }

    @Override
    public void execute() {
        if (this.alternateSourceFolder != null) {
            this.findPCCFiles(this.alternateSourceFolder);
        } else {
            String homebrewDataDir;
            this.findPCCFiles(new File(ConfigurationSettings.getPccFilesDir()));
            String vendorDataDir = PCGenSettings.getVendorDataDir();
            if (vendorDataDir != null) {
                this.findPCCFiles(new File(vendorDataDir));
            }
            if ((homebrewDataDir = PCGenSettings.getHomebrewDataDir()) != null) {
                this.findPCCFiles(new File(homebrewDataDir));
            }
        }
        this.setMaximum(this.campaignFiles.size());
        this.loadCampaigns();
        this.initCampaigns();
    }

    private void findPCCFiles(File aDirectory) {
        if (!aDirectory.exists() || !aDirectory.isDirectory()) {
            return;
        }
        for (File file : aDirectory.listFiles(this.pccFileFilter)) {
            if (file.isDirectory()) {
                this.findPCCFiles(file);
                continue;
            }
            this.campaignFiles.add(file.toURI());
        }
    }

    private void loadCampaigns() {
        int progress = 0;
        CampaignLoader campaignLoader = new CampaignLoader();
        while (!this.campaignFiles.isEmpty()) {
            URI uri = this.campaignFiles.poll();
            if (Globals.getCampaignByURI(uri, false) == null) {
                try {
                    campaignLoader.loadCampaignLstFile(uri);
                }
                catch (PersistenceLayerException ex) {
                    Logging.errorPrint("PersistanceLayer", ex);
                }
            }
            this.setProgress(++progress);
        }
    }

    private void initCampaigns() {
        ArrayList<Campaign> initialCampaigns = new ArrayList<Campaign>(Globals.getCampaignList());
        CampaignLoader campaignLoader = new CampaignLoader();
        for (Campaign c : initialCampaigns) {
            campaignLoader.initRecursivePccFiles(c);
        }
    }

    public File getAlternateSourceFolder() {
        return this.alternateSourceFolder;
    }

    public void setAlternateSourceFolder(File alternateSourceFolder) {
        this.alternateSourceFolder = alternateSourceFolder;
    }
}

