/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.HashMapToList;
import pcgen.core.Campaign;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.SourceEntry;
import pcgen.persistence.lst.URIEntry;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class CampaignSourceEntry
implements SourceEntry {
    private Campaign campaign = null;
    private List<String> excludeItems = new ArrayList<String>();
    private List<String> includeItems = new ArrayList<String>();
    private List<Prerequisite> prerequisites = new ArrayList<Prerequisite>();
    private URIEntry uri = null;

    public CampaignSourceEntry(Campaign campaign, URI lstLoc) {
        this.campaign = Objects.requireNonNull(campaign);
        this.uri = new URIEntry(campaign.getDisplayName(), Objects.requireNonNull(lstLoc));
    }

    public CampaignSourceEntry(Campaign campaign, URIEntry entry) {
        this.campaign = Objects.requireNonNull(campaign);
        this.uri = Objects.requireNonNull(entry);
    }

    @Override
    public Campaign getCampaign() {
        return this.campaign;
    }

    @Override
    public List<String> getExcludeItems() {
        return this.excludeItems;
    }

    @Override
    public URI getURI() {
        return this.uri.getURI();
    }

    @Override
    public List<String> getIncludeItems() {
        return this.includeItems;
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof CampaignSourceEntry)) {
            return false;
        }
        CampaignSourceEntry other = (CampaignSourceEntry)arg0;
        return this.uri.equals(other.uri) && this.excludeItems.equals(other.excludeItems) && this.includeItems.equals(other.includeItems);
    }

    public int hashCode() {
        return this.uri.getLSTformat().hashCode();
    }

    public String toString() {
        StringBuilder sBuff = new StringBuilder();
        sBuff.append("Campaign: ");
        sBuff.append(this.campaign.getDisplayName());
        sBuff.append("; SourceFile: ");
        sBuff.append(this.getURI());
        return sBuff.toString();
    }

    public static CampaignSourceEntry getNewCSE(Campaign campaign2, URI sourceUri, String value) {
        CampaignSourceEntry cse;
        if (value == null || value.isEmpty()) {
            Logging.errorPrint("Cannot build CampaignSourceEntry for empty value in " + sourceUri);
            return null;
        }
        int pipePos = value.indexOf("|");
        if (pipePos == -1) {
            if (value.startsWith("(")) {
                Logging.errorPrint("Invalid Campaign File, cannot start with (:" + value);
                return null;
            }
            URIEntry uri = URIEntry.getURIEntry(campaign2.getDisplayName(), sourceUri, value);
            cse = new CampaignSourceEntry(campaign2, uri);
        } else {
            URIEntry uri = URIEntry.getURIEntry(campaign2.getDisplayName(), sourceUri, value.substring(0, pipePos));
            cse = new CampaignSourceEntry(campaign2, uri);
            String inExString = value.substring(pipePos + 1);
            List<String> tagList = CampaignSourceEntry.parseSuffix(inExString, sourceUri, value);
            for (String tagString : tagList) {
                List<String> splitIncExc;
                if (tagString.startsWith("((")) {
                    Logging.errorPrint("Found Suffix in Campaign Source with multiple parenthesis: Single set of parens required around INCLUDE/EXCLUDE");
                    Logging.errorPrint("Found: '" + tagString + "' in " + value);
                    return null;
                }
                if (tagString.startsWith("(INCLUDE:")) {
                    splitIncExc = cse.splitInExString(tagString = inExString.substring(1, tagString.length() - 1));
                    if (splitIncExc == null) {
                        return null;
                    }
                    cse.includeItems = splitIncExc;
                    continue;
                }
                if (tagString.startsWith("(EXCLUDE:")) {
                    splitIncExc = cse.splitInExString(tagString = inExString.substring(1, tagString.length() - 1));
                    if (splitIncExc == null) {
                        return null;
                    }
                    cse.excludeItems = splitIncExc;
                    continue;
                }
                if (PreParserFactory.isPreReqString(tagString)) {
                    Prerequisite prereq;
                    try {
                        prereq = PreParserFactory.getInstance().parse(tagString);
                    }
                    catch (PersistenceLayerException e) {
                        Logging.errorPrint("Error Initializing PreParserFactory.", e);
                        return null;
                    }
                    if (prereq == null) {
                        Logging.errorPrint("Found invalid prerequisite in Campaign Source: '" + tagString + "' in " + value);
                        return null;
                    }
                    cse.prerequisites.add(prereq);
                    continue;
                }
                Logging.errorPrint("Invalid Suffix (must have '(INCLUDE' '(EXCLUDE' or a PRExxx immediately following the pipe (no spaces).  Found: '" + inExString + "' on Campaign Source: '" + value + "' in " + sourceUri);
                return null;
            }
            CampaignSourceEntry.validatePrereqs(cse.getPrerequisites(), sourceUri);
        }
        return cse;
    }

    static List<String> parseSuffix(String suffix, URI sourceUri, String value) {
        ArrayList<String> tagList = new ArrayList<String>();
        String currentTag = "";
        int bracketLevel = 0;
        StringTokenizer tokenizer = new StringTokenizer(suffix, "|()", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("(")) {
                currentTag = currentTag + token;
                ++bracketLevel;
                continue;
            }
            if (token.equals(")")) {
                if (bracketLevel > 0) {
                    --bracketLevel;
                }
                currentTag = currentTag + token;
                continue;
            }
            if (token.equals("|")) {
                if (bracketLevel > 0) {
                    currentTag = currentTag + token;
                    continue;
                }
                if (currentTag.length() <= 0) continue;
                tagList.add(currentTag);
                currentTag = "";
                continue;
            }
            currentTag = currentTag + token;
        }
        if (currentTag.length() > 0) {
            tagList.add(currentTag);
        }
        if (bracketLevel > 0) {
            Logging.errorPrint("Suffix in Campaign Source with missing closing parenthesis, Found: '" + suffix + "' on Campaign Source: '" + value + "' in " + sourceUri);
            return null;
        }
        return tagList;
    }

    private static void validatePrereqs(List<Prerequisite> prereqList, URI sourceUri) {
        if (prereqList == null || prereqList.isEmpty()) {
            return;
        }
        for (Prerequisite prereq : prereqList) {
            if (prereq.isCharacterRequired()) {
                PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
                ArrayList<Prerequisite> displayList = new ArrayList<Prerequisite>();
                displayList.add(prereq);
                String lstString = prereqWriter.getPrerequisiteString(displayList, "\t");
                Logging.log(Logging.LST_ERROR, "Prereq '" + prereq.getKind() + "' is not supported in PCC files. Prereq was '" + lstString + "' in " + sourceUri + ". Prereq will be ignored.");
                continue;
            }
            CampaignSourceEntry.validatePrereqs(prereq.getPrerequisites(), sourceUri);
        }
    }

    private List<String> splitInExString(String inExString) {
        boolean hasCategory = false;
        boolean hasKeyOnly = false;
        ArrayList<String> catKeyList = new ArrayList<String>();
        String target = inExString.substring(8);
        if (target == null || target.length() == 0) {
            Logging.errorPrint("Must Specify Items after :");
            return null;
        }
        List<String> keyList = CoreUtility.split(target, '|');
        for (String key : keyList) {
            if (key.startsWith("CATEGORY=")) {
                hasCategory = true;
                List<String> abilityKeyList = CoreUtility.split(key.substring(9), ',');
                String category = abilityKeyList.get(0);
                abilityKeyList.remove(0);
                for (String string : abilityKeyList) {
                    catKeyList.add(category + ',' + string);
                }
                continue;
            }
            hasKeyOnly = true;
            catKeyList.add(key);
        }
        if (hasKeyOnly && hasCategory) {
            Logging.log(Logging.LST_ERROR, "Invalid " + inExString.substring(0, 7) + " value on " + this.uri.getLSTformat() + " in " + this.campaign.getDisplayName() + ". Abilities must always have categories (e.g. " + inExString.substring(0, 8) + "CATEGORY=cat1,key1,key2|CATEGORY=cat2,key1 ) and " + "other file types should never have categories (e.g. " + inExString.substring(0, 8) + "key1|key2 ).");
            return null;
        }
        return catKeyList;
    }

    public String getLSTformat() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.uri.getLSTformat());
        if (!this.includeItems.isEmpty()) {
            sb.append("|");
            sb.append("(INCLUDE:");
            sb.append((CharSequence)this.joinIncExcList(this.includeItems));
            sb.append(')');
        } else if (!this.excludeItems.isEmpty()) {
            sb.append("|");
            sb.append("(EXCLUDE:");
            sb.append((CharSequence)this.joinIncExcList(this.excludeItems));
            sb.append(')');
        }
        return sb.toString();
    }

    private StringBuilder joinIncExcList(List<String> list) {
        HashMapToList map = new HashMapToList();
        for (String s : list) {
            int commaLoc = s.indexOf(44);
            if (commaLoc == -1) {
                return StringUtil.joinToStringBuilder(list, (String)"|");
            }
            map.addToListFor((Object)s.substring(0, commaLoc), (Object)s.substring(commaLoc + 1));
        }
        StringBuilder sb = new StringBuilder(200);
        boolean needPipe = false;
        for (String category : map.getKeySet()) {
            if (needPipe) {
                sb.append("|");
            }
            needPipe = true;
            sb.append("CATEGORY=");
            sb.append(category);
            sb.append(",");
            sb.append((CharSequence)StringUtil.joinToStringBuilder((Collection)map.getListFor((Object)category), (String)","));
        }
        return sb;
    }

    public CampaignSourceEntry getRelatedTarget(String fileName) {
        return new CampaignSourceEntry(this.campaign, this.uri.getRelatedTarget(fileName));
    }

    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }
}

