/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.SourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class FeatLoader
extends AbilityLoader {
    private boolean defaultFeatsLoaded = false;

    @Override
    public Ability parseLine(LoadContext context, Ability aFeat, String lstLine, SourceEntry source) throws PersistenceLayerException {
        Ability feat = aFeat;
        if (feat == null) {
            feat = new Ability();
            int tabLoc = lstLine.indexOf("\t");
            String name = tabLoc == -1 ? lstLine : lstLine.substring(0, tabLoc);
            feat.setName(name.intern());
            feat.setCDOMCategory(AbilityCategory.FEAT);
            context.addStatefulInformation(feat);
            context.getReferenceContext().importObject(feat);
        } else {
            feat.setCDOMCategory(AbilityCategory.FEAT);
        }
        return super.parseLine(context, feat, lstLine, source);
    }

    @Override
    protected void loadLstFile(LoadContext context, CampaignSourceEntry sourceEntry) {
        super.loadLstFile(context, sourceEntry);
        if (!this.defaultFeatsLoaded) {
            this.loadDefaultFeats(context, sourceEntry);
        }
    }

    private void loadDefaultFeats(LoadContext context, CampaignSourceEntry firstSource) {
        Ability wpFeat = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, "PCGENi_WEAPON_PROFICIENCY");
        if (wpFeat == null) {
            String aLine = "PCGENi_WEAPON_PROFICIENCY\tOUTPUTNAME:Weapon Proficiency\tTYPE:General\tVISIBLE:NO\tMULT:YES\tSTACK:YES\tCHOOSE:NOCHOICE\tDESC:You attack with this specific weapon normally, non-proficiency incurs a -4 to hit penalty.\tSOURCELONG:PCGen Internal";
            try {
                this.parseLine(context, (Ability)null, aLine, (SourceEntry)firstSource);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint("Unable to parse the internal default feats '" + aLine + "': " + ple.getMessage());
            }
            this.defaultFeatsLoaded = true;
        }
    }

    @Override
    protected Ability getObjectKeyed(LoadContext context, String aKey) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, aKey);
    }

    @Override
    protected Ability getMatchingObject(LoadContext context, CDOMObject key) {
        return this.getObjectKeyed(context, key.getKeyName());
    }
}

