/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.UnreachableError;
import pcgen.core.SystemCollections;
import pcgen.core.system.MigrationRule;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.MigrationLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class MigrationLoader
extends LstLineFileLoader {
    private String invalidKeyPattern = ".*[,|\\||\\\\|:|;|%|\\*|=|\\[|\\]].*";
    private String invalidSourceKeyPattern = ".*[\\||\\\\|;|%|\\*|=|\\[|\\]].*";

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) throws PersistenceLayerException {
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        String firstToken = colToken.nextToken().trim();
        MigrationRule migrationRule = this.parseFirstToken(firstToken, lstLine, sourceURI);
        if (migrationRule == null) {
            return;
        }
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(MigrationLstToken.class);
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            int idxColon = colString.indexOf(58);
            String key = "";
            try {
                key = colString.substring(0, idxColon);
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            MigrationLstToken token = (MigrationLstToken)tokenMap.get(key);
            if (token != null) {
                String value = colString.substring(idxColon + 1);
                LstUtils.deprecationCheck(token, migrationRule.getOldKey(), sourceURI, value);
                if (token.parse(migrationRule, value, this.getGameMode())) continue;
                Logging.errorPrint("Error parsing migration rule " + migrationRule.getOldKey() + ':' + sourceURI + ':' + colString + "\"");
                return;
            }
            Logging.errorPrint("Unknown token " + key + " in migration rule '" + lstLine + "' in " + sourceURI.toString());
            return;
        }
        boolean errorFound = false;
        if (migrationRule.getMaxVer() == null) {
            Logging.errorPrint("Missing required token MAXVER in migration rule '" + lstLine + "' in " + sourceURI.toString());
            errorFound = true;
        }
        if (migrationRule.getNewKey() == null) {
            Logging.errorPrint("Missing required token NEWKEY in migration rule '" + lstLine + "' in " + sourceURI.toString());
            errorFound = true;
        }
        if (migrationRule.getMinVer() == null && migrationRule.getMinDevVer() != null) {
            Logging.errorPrint("MINVER is required when MINDEVVER is used. Migration rule was '" + lstLine + "' in " + sourceURI.toString());
            errorFound = true;
        }
        if (migrationRule.getMaxVer() != null && migrationRule.getMaxDevVer() != null && CoreUtility.compareVersions(migrationRule.getMaxVer(), migrationRule.getMaxDevVer()) >= 0) {
            Logging.errorPrint("MAXVER must be before MAXDEVVER. Migration rule was '" + lstLine + "' in " + sourceURI.toString());
            errorFound = true;
        }
        if (migrationRule.getMinVer() != null && migrationRule.getMinDevVer() != null && CoreUtility.compareVersions(migrationRule.getMinVer(), migrationRule.getMinDevVer()) >= 0) {
            Logging.errorPrint("MINVER must be before MINDEVVER. Migration rule was '" + lstLine + "' in " + sourceURI.toString());
            errorFound = true;
        }
        if (errorFound) {
            return;
        }
        SystemCollections.addToMigrationRulesList(migrationRule, this.gameMode);
    }

    MigrationRule parseFirstToken(String firstToken, String lstLine, URI sourceURI) {
        MigrationRule rule;
        MigrationRule.ObjectType objType;
        int idxColon = firstToken.indexOf(58);
        if (idxColon <= 0 || idxColon == firstToken.length() - 1) {
            Logging.errorPrint("Illegal migration rule '" + lstLine + "' in " + sourceURI.toString());
            return null;
        }
        String objTypeKey = "";
        try {
            objTypeKey = firstToken.substring(0, idxColon);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new UnreachableError((Throwable)e);
        }
        try {
            objType = MigrationRule.ObjectType.valueOf(objTypeKey);
        }
        catch (IllegalArgumentException e) {
            Logging.errorPrint("Unknown object type for migration rule '" + lstLine + "' in " + sourceURI.toString());
            return null;
        }
        String key = "";
        try {
            key = firstToken.substring(idxColon + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new UnreachableError((Throwable)e);
        }
        if (objType.isCategorized()) {
            if (key.endsWith("|")) {
                Logging.errorPrint("Invalid category|key of '" + firstToken + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            String[] keyParts = key.split("\\|");
            if (keyParts.length < 2) {
                Logging.errorPrint("Missing category in '" + firstToken + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            if (keyParts.length > 2) {
                Logging.errorPrint("Invalid category|key of '" + firstToken + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            if (StringUtils.isBlank(keyParts[0]) || keyParts[0].matches(this.invalidKeyPattern)) {
                Logging.errorPrint("Invalid category of '" + keyParts[0] + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            if (StringUtils.isBlank(keyParts[1]) || keyParts[1].matches(this.invalidKeyPattern)) {
                Logging.errorPrint("Invalid key of '" + keyParts[1] + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            rule = new MigrationRule(objType, keyParts[0], keyParts[1]);
        } else {
            String invalidKeyPat;
            String string = invalidKeyPat = objType == MigrationRule.ObjectType.SOURCE ? this.invalidSourceKeyPattern : this.invalidKeyPattern;
            if (StringUtils.isBlank(key) || key.matches(invalidKeyPat)) {
                Logging.errorPrint("Invalid key of '" + key + "' of migration rule '" + lstLine + "' in " + sourceURI.toString());
                return null;
            }
            rule = new MigrationRule(objType, key);
        }
        return rule;
    }
}

