/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.Loadable;
import pcgen.persistence.lst.SimpleLoader;
import pcgen.rules.context.LoadContext;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class SimplePrefixLoader<T extends Loadable>
extends SimpleLoader<T> {
    private final String prefixString;

    public SimplePrefixLoader(Class<T> cl, String prefix) {
        super(cl);
        if (Objects.requireNonNull(prefix).isEmpty()) {
            throw new IllegalArgumentException("Prefix cannot be empty");
        }
        this.prefixString = prefix;
    }

    @Override
    protected String processFirstToken(LoadContext context, String token) {
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: '" + token + "' in " + this.getLoadClass().getSimpleName());
            return null;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: '" + token + "' in " + this.getLoadClass().getSimpleName());
            return null;
        }
        if (colonLoc == token.length() - 1) {
            Logging.errorPrint("Invalid Token - ends with a colon (no value): '" + token + "' in " + this.getLoadClass().getSimpleName());
            return null;
        }
        String key = token.substring(0, colonLoc);
        if (!this.prefixString.equals(key)) {
            Logging.errorPrint("Invalid Token - expected '" + this.prefixString + "' to be the first key in " + this.getLoadClass().getSimpleName());
            return null;
        }
        String firstTokenValue = token.substring(colonLoc + 1);
        if (StringUtils.isNotBlank(firstTokenValue) && firstTokenValue.startsWith("in_")) {
            firstTokenValue = LanguageBundle.getString(firstTokenValue);
        }
        return super.processFirstToken(context, firstTokenValue);
    }
}

