/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.content.BonusSpellInfo;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCStat;
import pcgen.persistence.lst.SimpleLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class StatsAndChecksLoader
extends SimpleLoader<Loadable> {
    public StatsAndChecksLoader() {
        super(Loadable.class);
    }

    @Override
    protected Loadable getLoadable(LoadContext context, String token, URI sourceURI) {
        Class loadClass;
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: '" + token + "' in " + sourceURI);
            return null;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: '" + token + "' in " + sourceURI);
            return null;
        }
        if (colonLoc == token.length() - 1) {
            Logging.errorPrint("Invalid Token - ends with a colon (no value): '" + token + "' in " + sourceURI);
            return null;
        }
        String key = token.substring(0, colonLoc);
        if ("STATNAME".equals(key)) {
            Logging.deprecationPrint("Loading Stats in Game Mode is deprecated, please use the STAT: token in a PCC file");
            loadClass = PCStat.class;
        } else if ("CHECKNAME".equals(key)) {
            Logging.deprecationPrint("Loading Checks/Saves in Game Mode is deprecated, please use the SAVE: token in a PCC file");
            loadClass = PCCheck.class;
        } else if ("BONUSSPELLLEVEL".equals(key)) {
            loadClass = BonusSpellInfo.class;
        } else if ("ALIGNMENTNAME".equals(key)) {
            Logging.deprecationPrint("Loading Alignments in Game Mode is deprecated, please use the ALIGNMENT: token in a PCC file");
            loadClass = PCAlignment.class;
        } else {
            Logging.errorPrint("Invalid Token '" + key + "' as the first key in " + sourceURI);
            return null;
        }
        String name = token.substring(colonLoc + 1);
        if (name == null || name.length() == 0) {
            Logging.errorPrint("Invalid Token '" + key + "' had no value in " + sourceURI);
            return null;
        }
        PCStat loadable = context.getReferenceContext().constructCDOMObject(loadClass, name.intern());
        loadable.setSourceURI(sourceURI);
        return loadable;
    }
}

