/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import pcgen.util.Logging;

public abstract class VersionAwareToken {
    public abstract String getTokenName();

    protected boolean validateVersionNumber(String version) {
        String[] tokens = version.split(" |\\.|\\-", 4);
        if (tokens.length < 3) {
            Logging.log(Logging.LST_ERROR, "Invalid version in " + this.getTokenName() + ":" + version + " must have 3 number parts e.g. " + this.getTokenName() + ":6.0.2");
            return false;
        }
        for (int idx = 0; idx < 3 && idx < tokens.length; ++idx) {
            try {
                Integer.parseInt(tokens[idx]);
                continue;
            }
            catch (NumberFormatException e) {
                if (idx == 2 && tokens[idx].startsWith("RC")) continue;
                Logging.log(Logging.LST_ERROR, "Invalid version in " + this.getTokenName() + ":" + version + " must have 3 number parts e.g. " + this.getTokenName() + ":6.0.2");
                return false;
            }
        }
        return true;
    }
}

