/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;
import pcgen.core.SettingsHandler;
import pcgen.rules.context.LoadContext;
import pcgen.system.LanguageBundle;
import pcgen.util.PCGenLogLevel;

public class Logging {
    private static boolean debugMode = false;
    private static final Toolkit s_TOOLKIT = Toolkit.getDefaultToolkit();
    public static final Level ERROR = Level.SEVERE;
    public static final Level LST_ERROR = PCGenLogLevel.LST_ERROR;
    public static final Level WARNING = Level.WARNING;
    public static final Level LST_WARNING = PCGenLogLevel.LST_WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level LST_INFO = PCGenLogLevel.LST_INFO;
    public static final Level DEBUG = Level.FINER;
    private static Logger pcgenLogger;
    private static Logger pluginLogger;
    private static LinkedList<QueuedMessage> queuedMessages;
    private static int queuedMessageMark;

    public static void setDebugMode(boolean argDebugMode) {
        Logging.retainRootLoggers();
        debugMode = argDebugMode;
        if (debugMode) {
            Logger.getLogger("pcgen").setLevel(DEBUG);
            Logger.getLogger("plugin").setLevel(DEBUG);
        } else {
            Logger.getLogger("pcgen").setLevel(LST_WARNING);
            Logger.getLogger("plugin").setLevel(LST_WARNING);
        }
    }

    private static void retainRootLoggers() {
        pcgenLogger = Logger.getLogger("pcgen");
        pluginLogger = Logger.getLogger("plugin");
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static boolean isLoggable(Level level) {
        Logger l = Logging.getLogger();
        return l != null && l.isLoggable(level);
    }

    public static void debugPrint(String s) {
        Logger l = Logging.getLogger();
        if (l != null && l.isLoggable(DEBUG)) {
            l.log(DEBUG, s);
        }
    }

    public static void debugPrint(String param1, Object param2) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(DEBUG)) {
            l.log(DEBUG, param1 + param2);
        }
    }

    public static void debugPrintLocalised(String message, Object ... params) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(DEBUG)) {
            String msg = LanguageBundle.getFormattedString(message, params);
            l.log(DEBUG, msg);
        }
    }

    public static void debugPrint(String s, Throwable thr) {
        Logging.debugPrint(s);
        Logger l = Logging.getLogger();
        if (l != null && l.isLoggable(DEBUG)) {
            thr.printStackTrace(System.err);
        }
    }

    public static void errorPrintLocalised(String aKey) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String msg = LanguageBundle.getString(aKey);
        System.err.println(msg);
    }

    public static void errorPrintLocalised(String aKey, Object ... varargs) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String msg = LanguageBundle.getFormattedString(aKey, varargs);
        Logger l = Logging.getLogger();
        if (l.isLoggable(ERROR)) {
            l.log(ERROR, msg);
        }
    }

    public static void deprecationPrint(String s) {
        Logging.deprecationPrint(s, null);
    }

    public static void deprecationPrint(String s, LoadContext context) {
        Logger l;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((l = Logging.getLogger()).isLoggable(LST_WARNING) && SettingsHandler.outputDeprecationMessages()) {
            if (context != null && context.getSourceURI() != null) {
                l.log(LST_WARNING, s + " (Source: " + context.getSourceURI() + " )");
            } else {
                l.log(LST_WARNING, s);
            }
        }
    }

    public static void reportSource(Level lvl, LoadContext context) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(lvl)) {
            if (context != null && context.getSourceURI() != null) {
                l.log(lvl, " (Source: " + context.getSourceURI() + " )");
            } else {
                l.log(lvl, " (Source unknown)");
            }
        }
    }

    public static void reportSource(Level lvl, URI sourceUri) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(lvl)) {
            if (sourceUri != null) {
                l.log(lvl, " (Source: " + sourceUri + ")");
            } else {
                l.log(lvl, " (Source unknown)");
            }
        }
    }

    public static void errorPrint(String s) {
        Logger l;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((l = Logging.getLogger()).isLoggable(ERROR)) {
            l.log(ERROR, s);
        }
    }

    public static void errorPrint(String s, Object ... params) {
        Logger l;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((l = Logging.getLogger()).isLoggable(ERROR)) {
            l.log(ERROR, s, params);
        }
    }

    public static void errorPrint(String s, LoadContext context) {
        Logger l;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((l = Logging.getLogger()).isLoggable(ERROR)) {
            if (context != null && context.getSourceURI() != null) {
                l.log(ERROR, s + " (Source: " + context.getSourceURI() + " )");
            } else {
                l.log(ERROR, s);
            }
        }
    }

    public static void errorPrint(String s, URI sourceURI) {
        Logger l;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((l = Logging.getLogger()).isLoggable(ERROR)) {
            if (sourceURI != null) {
                l.log(ERROR, s + " (Source: " + sourceURI + " )");
            } else {
                l.log(ERROR, s);
            }
        }
    }

    public static void errorPrint(String s, Throwable thr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        thr.printStackTrace(ps);
        Logging.errorPrint(s + "\n" + baos.toString());
    }

    public static void log(Level lvl, String msg) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(lvl)) {
            l.log(lvl, msg);
        }
    }

    public static void log(Level lvl, String msg, Throwable thr) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(lvl)) {
            l.log(lvl, msg, thr);
        }
    }

    public static void log(Level lvl, String msg, StackTraceElement[] stackTrace) {
        Logger l = Logging.getLogger();
        if (l.isLoggable(lvl)) {
            l.log(lvl, msg, stackTrace);
        }
    }

    public static void errorPrintLocalised(String s, Throwable thr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        thr.printStackTrace(ps);
        Logging.errorPrint(LanguageBundle.getString(s) + "\n" + baos.toString());
    }

    public static void memoryReport() {
        System.out.println(Logging.memoryReportStr());
    }

    public static String memoryReportStr() {
        Runtime rt = Runtime.getRuntime();
        NumberFormat numFmt = NumberFormat.getNumberInstance();
        StringBuilder sb = new StringBuilder("Memory: ");
        sb.append(numFmt.format((double)rt.totalMemory() / 1024.0));
        sb.append("Kb total, ");
        sb.append(numFmt.format((double)rt.freeMemory() / 1024.0));
        sb.append("Kb free, ");
        sb.append(numFmt.format((double)rt.maxMemory() / 1024.0));
        sb.append("Kb max.");
        return sb.toString();
    }

    private static Logger getLogger() {
        int retries;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement caller = null;
        for (int i = 1; i < stack.length; ++i) {
            if ("pcgen.util.Logging".equals(stack[i].getClassName())) continue;
            caller = stack[i];
            break;
        }
        String name = caller == null ? "" : caller.getClassName();
        Logger l = null;
        int maxRetries = 15;
        for (retries = 0; l == null && retries < 15; ++retries) {
            l = Logger.getLogger(name);
        }
        if (l == null) {
            System.err.println("Unable to get logger for " + name + " after " + retries + " atempts.");
        }
        return l;
    }

    public static void reportAllThreads() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        StringBuilder b = new StringBuilder();
        for (Thread t : allThreads.keySet()) {
            StackTraceElement[] traces;
            b.append("Thread: ");
            b.append(t.getName());
            b.append(", stacktrace:\n");
            for (StackTraceElement element : traces = allThreads.get(t)) {
                b.append("  ");
                b.append(element.toString());
                b.append("\n");
            }
        }
        System.out.println("==== Thread listing ====");
        System.out.println(b);
        System.out.println("===== end listing  =====");
    }

    public static void registerHandler(Handler handler) {
        Logger.getLogger("").addHandler(handler);
    }

    public static void removeHandler(Handler handler) {
        Logger.getLogger("").removeHandler(handler);
    }

    public static List<Level> getLoggingLevels() {
        ArrayList<Level> levels = new ArrayList<Level>();
        levels.add(ERROR);
        levels.add(LST_ERROR);
        levels.add(WARNING);
        levels.add(LST_WARNING);
        levels.add(INFO);
        levels.add(LST_INFO);
        levels.add(DEBUG);
        return levels;
    }

    public static Level getCurrentLoggingLevel() {
        return Logger.getLogger("pcgen").getLevel();
    }

    public static void setCurrentLoggingLevel(Level level) {
        Logging.retainRootLoggers();
        debugMode = level == DEBUG;
        Logger.getLogger("pcgen").setLevel(level);
        Logger.getLogger("plugin").setLevel(level);
    }

    public static void addParseMessage(Level lvl, String msg) {
        queuedMessages.add(new QueuedMessage(lvl, msg));
    }

    public static void addParseMessage(Level lvl, String msg, StackTraceElement[] stack) {
        queuedMessages.add(new QueuedMessage(lvl, msg, stack));
    }

    public static void markParseMessages() {
        queuedMessageMark = queuedMessages.size();
    }

    public static void rewindParseMessages() {
        while (queuedMessageMark > -1 && queuedMessages.size() > queuedMessageMark) {
            queuedMessages.removeLast();
        }
    }

    public static void replayParsedMessages() {
        Logger l = Logging.getLogger();
        for (QueuedMessage msg : queuedMessages) {
            if (!l.isLoggable(msg.level)) continue;
            l.log(msg.level, msg.message, msg.stackTrace);
        }
        queuedMessageMark = -1;
    }

    public static void clearParseMessages() {
        queuedMessageMark = -1;
        queuedMessages.clear();
    }

    static {
        Properties p = System.getProperties();
        File propsFile = new File(SystemUtils.USER_DIR + File.separator + "logging.properties");
        if (!propsFile.exists()) {
            propsFile = new File("logging.properties");
        }
        if (propsFile.exists() && null == p.get("java.util.logging.config.file")) {
            p.put("java.util.logging.config.file", propsFile.getAbsolutePath());
        }
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (SecurityException e) {
            System.err.println("Failed to read logging configuration. Error was:");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Failed to read logging configuration. Error was:");
            e.printStackTrace();
        }
        queuedMessages = new LinkedList();
        queuedMessageMark = -1;
    }

    private static class QueuedMessage {
        public final Level level;
        public final String message;
        public final StackTraceElement[] stackTrace;

        public QueuedMessage(Level lvl, String msg) {
            this.level = lvl;
            this.message = msg;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }

        public QueuedMessage(Level lvl, String msg, StackTraceElement[] stack) {
            this.level = lvl;
            this.message = msg;
            this.stackTrace = stack;
        }
    }
}

