/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nfunk.jep.ParseException;

public class ParameterTree {
    String contents;
    ParameterTree left = null;
    ParameterTree right = null;
    public static final String orString = "[or]";
    public static final String andString = "[and]";
    static String orPatString = "\\[or\\]";
    static String andPatString = "\\[and\\]";
    private static String leftBracket = "(";
    private static String leftPatString = "\\(";
    private static String rightPatString = "\\)";
    static String patString = "(" + leftPatString + "|" + rightPatString + "|" + orPatString + "|" + andPatString + ")";
    static Pattern pat = Pattern.compile(patString);
    private static final String parenString = "(" + leftPatString + "|" + rightPatString + ")";
    private static final Pattern parenPattern = Pattern.compile(parenString);
    private static final String operatorString = "(" + orPatString + "|" + andPatString + ")";
    private static final Pattern operatorPattern = Pattern.compile(operatorString);

    private static int getIndexOfClosingParen(String s, int start) throws ParseException {
        Matcher aMat = parenPattern.matcher(s);
        aMat.find(start);
        int level = 1;
        while (level > 0) {
            if (!aMat.find()) {
                throw new ParseException("unbalanced parenthesis in " + s);
            }
            if (leftBracket.equalsIgnoreCase(aMat.group())) {
                ++level;
                continue;
            }
            --level;
        }
        return aMat.end();
    }

    public static ParameterTree makeTree(String source) throws ParseException {
        Matcher mat = pat.matcher(source);
        if (mat.find()) {
            return ParameterTree.makeTree(source, false);
        }
        return new ParameterTree(source);
    }

    private static ParameterTree makeTree(String source, boolean operatorNeeded) throws ParseException {
        ParameterTree t;
        Matcher pM = parenPattern.matcher(source);
        boolean hasP = pM.find();
        if (hasP) {
            String pre = source.substring(0, pM.start());
            int end = ParameterTree.getIndexOfClosingParen(source, pM.start());
            if (0 == pre.length()) {
                String inside = source.substring(pM.end(), end - 1);
                t = ParameterTree.makeTree(inside, false);
            } else {
                t = ParameterTree.toTree(pre, operatorNeeded);
                Matcher rM = operatorPattern.matcher(t.getContents());
                if (rM.find()) {
                    if (t.getRightTree() == null) {
                        String inside = source.substring(pM.end(), end - 1);
                        t.setRightTree(ParameterTree.makeTree(inside, false));
                    } else {
                        StringBuilder rNodeContents = new StringBuilder();
                        rNodeContents.append(t.getRightTree().getContents());
                        rNodeContents.append(source.substring(pM.start(), end));
                    }
                } else {
                    String parenExp = source.substring(pM.end() - 1, end);
                    StringBuilder rNodeContents = new StringBuilder();
                    rNodeContents.append(t.getContents()).append(parenExp);
                    t.setContents(rNodeContents.toString());
                }
            }
            if (end < source.length()) {
                ParameterTree r;
                String sEnd = source.substring(end);
                ParameterTree c = r = ParameterTree.makeTree(sEnd, true);
                Matcher cM = operatorPattern.matcher(r.getContents());
                if (!cM.find()) {
                    throw new ParseException("expected \"" + source.substring(end) + "\" to begin with an operator");
                }
                while (c.getLeftTree() != null) {
                    c = c.getLeftTree();
                }
                c.setLeftTree(t);
                t = r;
            }
        } else {
            t = ParameterTree.toTree(source, operatorNeeded);
        }
        return t;
    }

    private static ParameterTree toTree(String source, boolean operatorNeeded) throws ParseException {
        String s = source;
        Matcher oM = operatorPattern.matcher(s);
        ParameterTree cT = new ParameterTree("");
        boolean hasO = oM.find();
        if (hasO && operatorNeeded) {
            if (oM.start() != 0) {
                throw new ParseException("expected \"" + s + "\" to begin with an operator");
            }
            cT = new ParameterTree(oM.group());
            int end = oM.end();
            s = s.substring(end);
            oM = operatorPattern.matcher(s);
            hasO = oM.find();
        }
        int start = 0;
        while (hasO) {
            String pre = s.substring(start, oM.start());
            ParameterTree P = new ParameterTree(pre);
            ParameterTree R = new ParameterTree(oM.group());
            Matcher cM = operatorPattern.matcher(cT.getContents());
            if (cM.find()) {
                cT.setRightTree(P);
                R.setLeftTree(cT);
            } else {
                R.setLeftTree(P);
            }
            cT = R;
            start = oM.end();
            hasO = oM.find();
        }
        if (start < s.length()) {
            ParameterTree p = new ParameterTree(s.substring(start));
            Matcher cM = operatorPattern.matcher(cT.getContents());
            if (cM.find()) {
                cT.setRightTree(p);
            } else {
                cT = p;
            }
        }
        return cT;
    }

    ParameterTree(String data) {
        this.contents = data;
    }

    public void setContents(String data) {
        this.contents = data;
    }

    public String getContents() {
        return this.contents;
    }

    public ParameterTree getLeftTree() {
        return this.left;
    }

    public void setLeftTree(ParameterTree l) {
        this.left = l;
    }

    public ParameterTree getRightTree() {
        return this.right;
    }

    public void setRightTree(ParameterTree r) {
        this.right = r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("[");
        sb.append(this.contents);
        sb.append(" ");
        if (this.left != null) {
            sb.append(this.left.toString());
        }
        if (this.right != null) {
            sb.append(this.right.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

