/*
 * Decompiled with CFR 0.152.
 */
package plugin.bonustokens;

import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.MissingObject;
import pcgen.rules.context.LoadContext;

public final class Stat
extends BonusObj {
    private static final String[] BONUS_TAGS = new String[]{"BASESPELLSTAT", "BASESPELLKNOWNSTAT"};

    @Override
    protected boolean parseToken(LoadContext context, String token) {
        for (int i = 0; i < BONUS_TAGS.length; ++i) {
            if (!BONUS_TAGS[i].equals(token)) continue;
            this.addBonusInfo(i);
            return true;
        }
        if (token.startsWith("CAST=") || token.startsWith("CAST.")) {
            PCStat stat = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, token.substring(5));
            if (stat != null) {
                this.addBonusInfo(new CastStat(stat));
                return true;
            }
        } else {
            PCStat stat = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, token);
            if (stat != null) {
                this.addBonusInfo(stat);
            } else {
                PCClass aClass = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, token);
                if (aClass != null) {
                    this.addBonusInfo(aClass);
                } else {
                    this.addBonusInfo(new MissingObject(token));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected String unparseToken(Object obj) {
        if (obj instanceof Integer) {
            return BONUS_TAGS[(Integer)obj];
        }
        if (obj instanceof CastStat) {
            return "CAST." + ((CastStat)obj).getStat().getKeyName();
        }
        if (obj instanceof PCClass) {
            return ((PCClass)obj).getKeyName();
        }
        if (obj instanceof MissingObject) {
            return ((MissingObject)obj).getObjectName();
        }
        return ((PCStat)obj).getKeyName();
    }

    @Override
    public String getBonusHandled() {
        return "STAT";
    }

    @Override
    public String getDescription() {
        PCStat pcstat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, this.getBonusInfo());
        if (pcstat != null) {
            return pcstat.getName();
        }
        return super.getDescription();
    }

    public static class CastStat {
        private final PCStat stat;

        public CastStat(PCStat argStat) {
            this.stat = argStat;
        }

        public PCStat getStat() {
            return this.stat;
        }
    }
}

