/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.display.SkillDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;

public class SkillTypeToken
extends SkillToken {
    public static final String TOKEN_NAME = "SKILLTYPE";

    @Override
    public String getTokenName() {
        return TOKEN_NAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        SkillToken.SkillDetails details = SkillTypeToken.buildSkillDetails(tokenSource);
        if (details.getPropertyCount() < 2) {
            return "";
        }
        Skill aSkill = this.getSkill(tokenSource, pc, details, eh);
        return this.getSkillProperty(aSkill, details.getProperty(1), pc);
    }

    private Skill getSkill(String tokenSource, PlayerCharacter pc, SkillToken.SkillDetails details, ExportHandler eh) {
        int skillIndex;
        try {
            skillIndex = Integer.parseInt(details.getSkillId());
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Error replacing SKILLTYPE." + tokenSource, exc);
            return null;
        }
        ArrayList<Skill> skillSubset = new ArrayList<Skill>();
        for (Skill bSkill : SkillDisplay.getSkillListInOutputOrder(pc)) {
            if (!bSkill.isType(details.getProperty(0))) continue;
            skillSubset.add(bSkill);
        }
        if (skillIndex >= skillSubset.size() - 1 && eh != null && eh.getExistsOnly()) {
            eh.setNoMoreItems(true);
        }
        Skill aSkill = null;
        if (skillIndex <= skillSubset.size() - 1) {
            aSkill = (Skill)skillSubset.get(skillIndex);
        }
        return aSkill;
    }
}

