/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.cdom.base.Constants;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class SpecialAbilityToken
extends Token {
    public static final String TOKENNAME = "SPECIALABILITY";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String subToken;
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int i = 0;
        if (aTok.hasMoreTokens()) {
            i = Integer.parseInt(aTok.nextToken());
        }
        if (aTok.hasMoreTokens() && "DESCRIPTION".equals(subToken = aTok.nextToken())) {
            return SpecialAbilityToken.getDescriptionToken(pc, i);
        }
        return SpecialAbilityToken.getSpecialAbilityToken(pc, i);
    }

    public static String getSpecialAbilityToken(PlayerCharacter pc, int specialIndex) {
        if (specialIndex >= 0 && specialIndex < pc.getSpecialAbilityTimesList().size()) {
            return pc.getSpecialAbilityTimesList().get(specialIndex);
        }
        return "";
    }

    public static String getDescriptionToken(PlayerCharacter pc, int specialIndex) {
        if (specialIndex >= 0 && specialIndex < pc.getSpecialAbilityTimesList().size() && SettingsHandler.isROG()) {
            if ("EMPTY".equals(pc.getDescriptionLst())) {
                pc.loadDescriptionFilesInDirectory("descriptions");
            }
            String description = "";
            String search = "SA:" + pc.getSpecialAbilityTimesList().get(specialIndex) + Constants.LINE_SEPARATOR;
            int pos = pc.getDescriptionLst().indexOf(search);
            if (pos >= 0) {
                description = pc.getDescriptionLst().substring(pos + search.length());
                description = description.substring(0, description.indexOf("####") - 1).trim();
            }
            return description;
        }
        return "";
    }
}

