/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.MapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.helper.AbilitySelector;
import pcgen.cdom.helper.AbilityTargetSelector;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class AbilityLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
DeferredToken<CDOMObject> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;

    @Override
    public String getTokenName() {
        return "ABILITY";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        ListKey<ChooseSelectionActor> glk;
        Nature nature;
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        String cat = tok.nextToken();
        CDOMSingleRef<AbilityCategory> acRef = context.getReferenceContext().getCDOMReference(ABILITY_CATEGORY_CLASS, cat);
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a Nature, " + "Format is: CATEGORY|NATURE|AbilityName: " + value, context);
        }
        String natureKey = tok.nextToken();
        try {
            nature = Nature.valueOf(natureKey);
        }
        catch (IllegalArgumentException iae) {
            return new ParseResult.Fail(this.getTokenName() + " refers to invalid Ability Nature: " + natureKey, context);
        }
        if (Nature.ANY.equals((Object)nature)) {
            return new ParseResult.Fail(this.getTokenName() + " refers to ANY Ability Nature, cannot be used in " + this.getTokenName() + ": " + value, context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have abilities, Format is: " + "CATEGORY|NATURE|AbilityName: " + value, context);
        }
        String token = tok.nextToken();
        if (this.looksLikeAPrerequisite(token)) {
            return new ParseResult.Fail("Cannot have only PRExxx subtoken in " + this.getTokenName() + ": " + value, context);
        }
        String lkString = "GA_CA_" + cat + "_" + natureKey;
        ListKey<ChooseSelectionActor> lk = glk = ListKey.getKeyFor(ChooseSelectionActor.class, lkString);
        ArrayList<PrereqObject> edgeList = new ArrayList<PrereqObject>();
        CDOMReference<AbilityList> abilList = AbilityList.getAbilityListReference(acRef, nature);
        boolean first = true;
        boolean removed = false;
        ReferenceManufacturer<Ability> rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, ABILITY_CATEGORY_CLASS, cat);
        if (rm == null) {
            return new ParseResult.Fail("Could not get Reference Manufacturer for Category: " + cat, context);
        }
        boolean prereqsAllowed = true;
        do {
            if (".CLEAR".equals(token)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), obj, abilList);
                context.getObjectContext().removeFromList(obj, ListKey.GA_CAKEYS, lk);
                context.getObjectContext().removeList(obj, lk);
                removed = true;
            } else if (token.startsWith(".CLEAR.")) {
                String clearText = token.substring(7);
                CDOMReference<Ability> ref = TokenUtilities.getTypeOrPrimitive(rm, clearText);
                if (ref == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                AssociatedPrereqObject assoc = context.getListContext().removeFromList(this.getTokenName(), obj, abilList, ref);
                assoc.setAssociation(AssociationKey.NATURE, nature);
                assoc.setAssociation(AssociationKey.CATEGORY, acRef);
                removed = true;
            } else if ("%LIST".equals(token)) {
                prereqsAllowed = false;
                AbilitySelector as = new AbilitySelector(this.getTokenName(), acRef, nature);
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, as);
            } else {
                CDOMReference<Ability> ability = TokenUtilities.getTypeOrPrimitive(rm, token);
                if (ability == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                ability.setRequiresTarget(true);
                boolean loadList = true;
                ArrayList<String> choices = null;
                if (token.indexOf(40) != -1) {
                    choices = new ArrayList<String>();
                    AbilityUtilities.getUndecoratedName(token, choices);
                    if (choices.size() == 1 && "%LIST".equals(choices.get(0)) && ability instanceof CDOMSingleRef) {
                        CDOMSingleRef ref = (CDOMSingleRef)ability;
                        AbilityTargetSelector ats = new AbilityTargetSelector(this.getTokenName(), acRef, ref, nature);
                        context.getObjectContext().addToList(obj, ListKey.GA_CAKEYS, lk);
                        context.getObjectContext().addToList(obj, lk, ats);
                        edgeList.add(ats);
                        loadList = false;
                    }
                }
                if (loadList) {
                    AssociatedPrereqObject assoc = context.getListContext().addToList(this.getTokenName(), obj, abilList, ability);
                    assoc.setAssociation(AssociationKey.NATURE, nature);
                    assoc.setAssociation(AssociationKey.CATEGORY, acRef);
                    if (choices != null) {
                        assoc.setAssociation(AssociationKey.ASSOC_CHOICES, choices);
                    }
                    edgeList.add(assoc);
                }
            }
            if (!tok.hasMoreTokens()) {
                return ParseResult.SUCCESS;
            }
            first = false;
        } while (!this.looksLikeAPrerequisite(token = tok.nextToken()));
        if (removed || !prereqsAllowed) {
            return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR, .CLEAR., or %LIST in " + this.getTokenName(), context);
        }
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(token)) == null) {
                return new ParseResult.Fail("   (Did you put feats after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            for (PrereqObject edge : edgeList) {
                edge.addPrerequisite(prereq);
            }
            if (!tok.hasMoreTokens()) break;
            token = tok.nextToken();
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        StringBuilder sb;
        Collection<CDOMReference<CDOMList<?>>> changedLists = context.getListContext().getChangedLists(obj, AbilityList.class);
        Changes<ListKey<ChooseSelectionActor<?>>> actors = context.getObjectContext().getListChanges(obj, ListKey.GA_CAKEYS);
        TreeSet<String> returnSet = new TreeSet<String>();
        TripleKeyMapToList m = new TripleKeyMapToList();
        TripleKeyMapToList clear = new TripleKeyMapToList();
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Collection<ChooseSelectionActor<?>> listAdded = listChanges.getAdded();
        if (listAdded != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor chooseSelectionActor : listAdded) {
                if (!chooseSelectionActor.getSource().equals(this.getTokenName())) continue;
                try {
                    AbilitySelector as = (AbilitySelector)chooseSelectionActor;
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append(as.getAbilityCategory().getLSTformat(false)).append("|");
                    sb2.append((Object)as.getNature()).append("|");
                    sb2.append(as.getLstFormat());
                    returnSet.add(sb2.toString());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage(this.getTokenName() + " encountered error: " + e.getMessage());
                    return null;
                }
            }
        }
        for (CDOMReference cDOMReference : changedLists) {
            CDOMSingleRef<AbilityCategory> cat;
            Nature nature;
            MapToList mtl;
            AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), obj, cDOMReference);
            if (changes.includesGlobalClear()) {
                CDOMDirectSingleRef dr = (CDOMDirectSingleRef)cDOMReference;
                AbilityList al = (AbilityList)dr.resolvesTo();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(al.getCategory().getLSTformat(false)).append("|");
                stringBuilder.append((Object)al.getNature()).append("|");
                stringBuilder.append(".CLEAR");
                returnSet.add(stringBuilder.toString());
            }
            if ((mtl = changes.getAddedAssociations()) != null) {
                for (CDOMReference cDOMReference2 : mtl.getKeySet()) {
                    for (AssociatedPrereqObject assoc : mtl.getListFor((Object)cDOMReference2)) {
                        nature = assoc.getAssociation(AssociationKey.NATURE);
                        cat = assoc.getAssociation(AssociationKey.CATEGORY);
                        m.addToListFor((Object)nature, cat, assoc.getPrerequisiteList(), (Object)cDOMReference2);
                    }
                }
            }
            if ((mtl = changes.getRemovedAssociations()) == null) continue;
            for (CDOMReference cDOMReference3 : mtl.getKeySet()) {
                for (AssociatedPrereqObject assoc : mtl.getListFor((Object)cDOMReference3)) {
                    nature = assoc.getAssociation(AssociationKey.NATURE);
                    cat = assoc.getAssociation(AssociationKey.CATEGORY);
                    clear.addToListFor((Object)nature, cat, assoc.getPrerequisiteList(), (Object)cDOMReference3);
                }
            }
        }
        for (Nature nature : m.getKeySet()) {
            for (CDOMSingleRef category : m.getSecondaryKeySet((Object)nature)) {
                for (List list : m.getTertiaryKeySet((Object)nature, (Object)category)) {
                    sb = new StringBuilder();
                    sb.append(category.getLSTformat(false)).append("|");
                    sb.append((Object)nature);
                    List clearList = clear.removeListFor((Object)nature, (Object)category, (Object)list);
                    if (clearList != null && !clearList.isEmpty()) {
                        sb.append("|");
                        sb.append(".CLEAR.");
                        sb.append(ReferenceUtilities.joinLstFormat(clearList, "|.CLEAR."));
                    }
                    sb.append("|");
                    sb.append(ReferenceUtilities.joinLstFormat(m.getListFor((Object)nature, (Object)category, (Object)list), "|"));
                    if (list != null && !list.isEmpty()) {
                        sb.append("|");
                        sb.append(this.getPrerequisiteString(context, list));
                    }
                    returnSet.add(sb.toString());
                }
            }
        }
        for (Nature nature : clear.getKeySet()) {
            for (CDOMSingleRef category : clear.getSecondaryKeySet((Object)nature)) {
                for (List list : clear.getTertiaryKeySet((Object)nature, (Object)category)) {
                    sb = new StringBuilder();
                    sb.append(category.getLSTformat(false)).append("|");
                    sb.append((Object)nature).append("|").append(".CLEAR.");
                    sb.append(ReferenceUtilities.joinLstFormat(clear.getListFor((Object)nature, (Object)category, (Object)list), "|.CLEAR."));
                    if (list != null && !list.isEmpty()) {
                        sb.append("|");
                        sb.append(this.getPrerequisiteString(context, list));
                    }
                    returnSet.add(sb.toString());
                }
            }
        }
        Collection<ListKey<ChooseSelectionActor<?>>> addedActors = actors.getAdded();
        if (addedActors != null) {
            for (ListKey<ChooseSelectionActor<?>> lk : addedActors) {
                Changes<ChooseSelectionActor<?>> cras = context.getObjectContext().getListChanges(obj, lk);
                for (ChooseSelectionActor chooseSelectionActor : cras.getAdded()) {
                    if (!this.getTokenName().equals(chooseSelectionActor.getSource())) continue;
                    try {
                        AbilityTargetSelector ats = (AbilityTargetSelector)chooseSelectionActor;
                        StringBuilder sb4 = new StringBuilder();
                        sb4.append(ats.getAbilityCategory().getLSTformat(false)).append("|");
                        sb4.append((Object)ats.getNature()).append("|").append(chooseSelectionActor.getLstFormat());
                        List<Prerequisite> prereqs = ats.getPrerequisiteList();
                        if (prereqs != null && !prereqs.isEmpty()) {
                            sb4.append("|");
                            sb4.append(this.getPrerequisiteString(context, prereqs));
                        }
                        returnSet.add(sb4.toString());
                    }
                    catch (PersistenceLayerException e) {
                        context.addWriteMessage(this.getTokenName() + " encountered error: " + e.getMessage());
                        return null;
                    }
                }
            }
        }
        if (returnSet.isEmpty()) {
            return null;
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public boolean process(LoadContext context, CDOMObject cdo) {
        List<ListKey<ChooseSelectionActor<?>>> lkList = cdo.getListFor(ListKey.GA_CAKEYS);
        if (lkList != null) {
            for (ListKey<ChooseSelectionActor<?>> lk : lkList) {
                cdo.addAllToListFor(ListKey.NEW_CHOOSE_ACTOR, cdo.getListFor(lk));
            }
        }
        return true;
    }

    @Override
    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }
}

