/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractYesNoToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.util.Logging;

public class MultToken
extends AbstractYesNoToken<Ability>
implements CDOMPrimaryToken<Ability>,
PostDeferredToken<Ability> {
    @Override
    public String getTokenName() {
        return "MULT";
    }

    @Override
    protected ObjectKey<Boolean> getObjectKey() {
        return ObjectKey.MULTIPLE_ALLOWED;
    }

    @Override
    public Class<Ability> getTokenClass() {
        return Ability.class;
    }

    @Override
    public Class<Ability> getDeferredTokenClass() {
        return Ability.class;
    }

    @Override
    public boolean process(LoadContext context, Ability a) {
        if (a.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            if (a.get(ObjectKey.CHOOSE_INFO) == null) {
                Logging.errorPrint("Ability (" + a.getCategory() + ") " + a.getKeyName() + " had MULT:YES but no CHOOSE", context);
                return false;
            }
            if (a.getKeyName().contains("(")) {
                String base = AbilityUtilities.removeChoicesFromName(a.getKeyName());
                Ability conflict = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, a.getCDOMCategory(), base);
                if (conflict != null && conflict.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    Logging.errorPrint("Ability (" + a.getCategory() + ") " + conflict.getKeyName() + " had MULT:YES which " + "prohibits Ability Key with same base " + "and parenthesis, but data included: " + a.getKeyName(), context);
                    return false;
                }
            }
        } else if (a.get(ObjectKey.CHOOSE_INFO) != null) {
            Logging.errorPrint("Ability (" + a.getCategory() + ") " + a.getKeyName() + " had MULT:NO but did have CHOOSE", context);
            return false;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

