/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.EquipmentModifier;
import pcgen.core.SpecialProperty;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpropToken
extends AbstractTokenWithSeparator<EquipmentModifier>
implements CDOMPrimaryToken<EquipmentModifier> {
    @Override
    public String getTokenName() {
        return "SPROP";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, EquipmentModifier mod, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList(mod, ListKey.SPECIAL_PROPERTIES);
            return ParseResult.SUCCESS;
        }
        SpecialProperty sa = SpecialProperty.createFromLst(value);
        if (sa == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().addToList(mod, ListKey.SPECIAL_PROPERTIES, sa);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, EquipmentModifier mod) {
        Changes<SpecialProperty> changes = context.getObjectContext().getListChanges(mod, ListKey.SPECIAL_PROPERTIES);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection<SpecialProperty> added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            list.add(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            for (SpecialProperty sp : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(sp.getDisplayName());
                if (sp.hasPrerequisites()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, sp.getPrerequisiteList()));
                }
                list.add(sb.toString());
            }
        }
        if (list.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

