/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.content.ACControl;
import pcgen.core.GameMode;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GameModeLstToken;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class ActypeToken
implements GameModeLstToken {
    @Override
    public String getTokenName() {
        return "ACTYPE";
    }

    @Override
    public boolean parse(GameMode gameMode, String value, URI source) {
        StringTokenizer aTok = new StringTokenizer(value, "\t");
        if (!aTok.hasMoreTokens()) {
            Logging.errorPrint("Empty tag in miscinfo.ACTYPE");
            return false;
        }
        String acType = aTok.nextToken();
        while (aTok.hasMoreTokens()) {
            Collection<ACControl> controls;
            String aString = aTok.nextToken();
            if (aString.startsWith("ADD:")) {
                controls = this.parseACControl(aString.substring(4));
                if (controls == null) {
                    return false;
                }
                gameMode.addACAdds(acType, controls);
                continue;
            }
            if (aString.startsWith("REMOVE:")) {
                controls = this.parseACControl(aString.substring(7));
                if (controls == null) {
                    return false;
                }
                gameMode.addACRemoves(acType, controls);
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.ACTYPE: " + aString);
            return false;
        }
        return true;
    }

    private Collection<ACControl> parseACControl(String str) {
        ArrayList<ACControl> acTypes;
        block6: {
            String token;
            StringTokenizer st = new StringTokenizer(str, "|");
            acTypes = new ArrayList<ACControl>();
            while (!PreParserFactory.isPreReqString(token = st.nextToken())) {
                acTypes.add(new ACControl(token));
                if (st.hasMoreTokens()) continue;
                return acTypes;
            }
            if (acTypes.isEmpty()) {
                Logging.errorPrint("No types found in actype control: " + str);
                return null;
            }
            do {
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(token);
                    for (ACControl acc : acTypes) {
                        acc.addPrerequisite(prereq);
                    }
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                    return null;
                }
                if (!st.hasMoreTokens()) break block6;
            } while (PreParserFactory.isPreReqString(token = st.nextToken()));
            Logging.errorPrint("ERROR: Type found after PRExxx in actype control: " + str);
            return null;
        }
        return acTypes;
    }
}

