/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Language;
import pcgen.core.kit.KitLangBonus;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LangBonusToken
extends AbstractTokenWithSeparator<KitLangBonus>
implements CDOMPrimaryToken<KitLangBonus> {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    @Override
    public String getTokenName() {
        return "LANGBONUS";
    }

    @Override
    public Class<KitLangBonus> getTokenClass() {
        return KitLangBonus.class;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, KitLangBonus kitLangBonus, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            kitLangBonus.addLanguage(context.getReferenceContext().getCDOMReference(LANGUAGE_CLASS, tok.nextToken()));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitLangBonus kitLangBonus) {
        List<CDOMSingleRef<Language>> languages = kitLangBonus.getLanguages();
        if (languages == null || languages.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(languages, "|")};
    }
}

