/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Race;
import pcgen.core.kit.KitRace;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class RaceToken
extends AbstractNonEmptyToken<KitRace>
implements CDOMPrimaryToken<KitRace> {
    private static final Class<Race> RACE_CLASS = Race.class;

    @Override
    public String getTokenName() {
        return "RACE";
    }

    @Override
    public Class<KitRace> getTokenClass() {
        return KitRace.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitRace kitRace, String value) {
        if ("<none selected>".equals(value)) {
            ComplexParseResult pr = new ComplexParseResult();
            pr.addWarningMessage("NONESELECTED is not necessary in KIT RACE: Token is not processed");
            return pr;
        }
        CDOMSingleRef<Race> ref = context.getReferenceContext().getCDOMReference(RACE_CLASS, value);
        kitRace.setRace(ref);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitRace kitRace) {
        CDOMReference<Race> race = kitRace.getRace();
        if (race == null) {
            return null;
        }
        return new String[]{race.getLSTformat(false)};
    }
}

